/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyAgreeRecipient;
import org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.bouncycastle.jce.spec.MQVPublicKeySpec;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKeyAgreeRecipient(PrivateKey privateKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
        this.recipientKey = privateKey;
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String string) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceHelper(string));
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier, PublicKey publicKey, ASN1OctetString aSN1OctetString, PrivateKey privateKey) throws CMSException, GeneralSecurityException, IOException {
        Object object;
        String string = algorithmIdentifier.getAlgorithm().getId();
        if (string.equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            object = aSN1OctetString.getOctets();
            MQVuserKeyingMaterial mQVuserKeyingMaterial = MQVuserKeyingMaterial.getInstance((Object)ASN1Object.fromByteArray((byte[])object));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), mQVuserKeyingMaterial.getEphemeralPublicKey().getPublicKey().getBytes());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithmIdentifier.getAlgorithm());
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            publicKey = new MQVPublicKeySpec(publicKey, publicKey2);
            privateKey = new MQVPrivateKeySpec(privateKey, privateKey);
        }
        object = this.helper.createKeyAgreement(algorithmIdentifier.getAlgorithm());
        ((KeyAgreement)object).init(privateKey);
        ((KeyAgreement)object).doPhase(publicKey, true);
        return ((KeyAgreement)object).generateSecret(aSN1ObjectIdentifier.getId());
    }

    private Key unwrapSessionKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SecretKey secretKey, ASN1ObjectIdentifier aSN1ObjectIdentifier2, byte[] byArray) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = this.helper.createCipher(aSN1ObjectIdentifier);
        cipher.init(4, secretKey);
        return cipher.unwrap(byArray, this.helper.getBaseCipherName(aSN1ObjectIdentifier2), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        try {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = AlgorithmIdentifier.getInstance((Object)algorithmIdentifier.getParameters()).getAlgorithm();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithmIdentifier.getAlgorithm());
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            SecretKey secretKey = this.calculateAgreedWrapKey(algorithmIdentifier, aSN1ObjectIdentifier, publicKey, aSN1OctetString, this.recipientKey);
            return this.unwrapSessionKey(aSN1ObjectIdentifier, secretKey, algorithmIdentifier2.getAlgorithm(), byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }

    @Override
    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        return PrivateKeyInfo.getInstance((Object)this.recipientKey.getEncoded()).getAlgorithmId();
    }
}

