/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.module.db.internal.config.domain.database.AbstractVendorConfigFactoryBean;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.domain.type.StructuredDbType;

public class OracleConfigFactoryBean
extends AbstractVendorConfigFactoryBean {
    public static final String CURSOR_TYPE_NAME = "CURSOR";
    public static final int OPAQUE_TYPE_ID = 2007;
    public static final String XML_TYPE_INTERNAL_NAME = "SYS.XMLTYPE";
    public static final int CURSOR_TYPE_ID = -10;
    public static final String XML_TYPE_NAME = "XMLTYPE";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:thin:@";

    protected OracleConfigFactoryBean() {
        super(ORACLE_URL_PREFIX);
        this.setDriverClassName(DRIVER_CLASS_NAME);
    }

    @Override
    protected List<DbType> getVendorDataTypes() {
        ArrayList<DbType> dbTypes = new ArrayList<DbType>();
        dbTypes.add(new ResolvedDbType(-10, CURSOR_TYPE_NAME));
        dbTypes.add(new OracleXmlType());
        return dbTypes;
    }

    private static class OracleXmlType
    extends StructuredDbType {
        public OracleXmlType() {
            super(2007, OracleConfigFactoryBean.XML_TYPE_NAME, OracleConfigFactoryBean.XML_TYPE_INTERNAL_NAME);
        }

        @Override
        public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
            return statement.getSQLXML(index);
        }
    }
}

