/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.DynamicDbType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.resolver.param.ParamTypeResolver;

public class DefaultParamTypeResolver
implements ParamTypeResolver {
    protected final DbTypeManager dbTypeManager;
    private ParamTypeResolver metadataParamTypeResolver;

    protected DefaultParamTypeResolver(DbTypeManager dbTypeManager, ParamTypeResolver metadataParamTypeResolver) {
        this.dbTypeManager = dbTypeManager;
        this.metadataParamTypeResolver = metadataParamTypeResolver;
    }

    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        Map<Integer, DbType> metadataParamTypes = this.getParamTypesUsingMetadata(connection, queryTemplate);
        return this.resolveParamTypes(connection, queryTemplate, metadataParamTypes);
    }

    protected Map<Integer, DbType> resolveParamTypes(DbConnection connection, QueryTemplate queryTemplate, Map<Integer, DbType> metadataParamTypes) {
        HashMap<Integer, DbType> resolvedParamTypes = new HashMap<Integer, DbType>();
        for (QueryParam queryParam : queryTemplate.getParams()) {
            if (queryParam.getType() instanceof UnknownDbType) {
                resolvedParamTypes.put(queryParam.getIndex(), metadataParamTypes.get(queryParam.getIndex()));
                continue;
            }
            if (queryParam.getType() instanceof DynamicDbType) {
                DbType dbType = this.dbTypeManager.lookup(connection, queryParam.getType().getName());
                resolvedParamTypes.put(queryParam.getIndex(), dbType);
                continue;
            }
            resolvedParamTypes.put(queryParam.getIndex(), queryParam.getType());
        }
        return resolvedParamTypes;
    }

    protected Map<Integer, DbType> getParamTypesUsingMetadata(DbConnection connection, QueryTemplate queryTemplate) {
        Map<Integer, DbType> metadataParamTypes;
        try {
            metadataParamTypes = this.metadataParamTypeResolver.getParameterTypes(connection, queryTemplate);
        }
        catch (SQLException e) {
            metadataParamTypes = this.getParamTypesFromQueryTemplate(queryTemplate);
        }
        return metadataParamTypes;
    }

    private Map<Integer, DbType> getParamTypesFromQueryTemplate(QueryTemplate queryTemplate) {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        for (QueryParam queryParam : queryTemplate.getParams()) {
            paramTypes.put(queryParam.getIndex(), queryParam.getType());
        }
        return paramTypes;
    }
}

