/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXBMarshallerTransformer
extends AbstractTransformer {
    protected JAXBContext jaxbContext;
    protected Class<?> sourceClass;

    public JAXBMarshallerTransformer() {
        this.setReturnDataType(DataTypeFactory.create(OutputStream.class));
        this.registerSourceType(DataTypeFactory.OBJECT);
    }

    public JAXBMarshallerTransformer(JAXBContext jaxbContext, DataType returnType) {
        this();
        this.jaxbContext = jaxbContext;
        this.setReturnDataType(returnType);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.jaxbContext == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"jaxbContext"), (Initialisable)this);
        }
    }

    protected Object doTransform(final Object src, String encoding) throws TransformerException {
        try {
            final Marshaller m = this.jaxbContext.createMarshaller();
            if (this.getReturnClass().equals(String.class)) {
                StringWriter w = new StringWriter();
                m.marshal(src, (Writer)w);
                return ((Object)w).toString();
            }
            if (this.getReturnClass().isAssignableFrom(Writer.class)) {
                StringWriter w = new StringWriter();
                m.marshal(src, (Writer)w);
                return w;
            }
            if (Document.class.isAssignableFrom(this.getReturnClass())) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                m.marshal(src, (Node)doc);
                return doc;
            }
            if (OutputStream.class.isAssignableFrom(this.getReturnClass())) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                m.marshal(src, (OutputStream)out);
                return out;
            }
            if (OutputHandler.class.equals((Object)this.getReturnClass())) {
                return new OutputHandler(){

                    public void write(MuleEvent event, OutputStream out) throws IOException {
                        try {
                            m.marshal(src, out);
                        }
                        catch (JAXBException e) {
                            IOException iox = new IOException("failed to mashal objec tto XML");
                            iox.initCause(e);
                            throw iox;
                        }
                    }
                };
            }
            throw new TransformerException(CoreMessages.transformerInvalidReturnType((Class)this.getReturnClass(), (String)this.getName()));
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }
}

