/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.config.i18n.CoreMessages;
import org.mule.el.mvel.DelegateVariableResolverFactory;
import org.mule.el.mvel.EventVariableResolverFactory;
import org.mule.el.mvel.GlobalVariableResolverFactory;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.el.mvel.MessageVariableResolverFactory;
import org.mule.el.mvel.NullVariableResolverFactory;
import org.mule.el.mvel.StaticVariableResolverFactory;
import org.mule.el.mvel.VariableVariableResolverFactory;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class MVELExpressionLanguage
implements ExpressionLanguage,
Initialisable {
    protected ParserConfiguration parserConfiguration;
    protected MuleContext muleContext;
    protected MVELExpressionExecutor expressionExecutor;
    protected VariableResolverFactory staticContext;
    protected VariableResolverFactory globalContext;
    protected String globalFunctionsString;
    protected String globalFunctionsFile;
    protected Map<String, Function> globalFunctions = new HashMap<String, Function>();
    protected Map<String, String> aliases = new HashMap<String, String>();
    protected Map<String, Class<?>> imports = new HashMap();
    protected boolean autoResolveVariables = true;

    public MVELExpressionLanguage(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.parserConfiguration = this.createParserConfiguration();
        this.expressionExecutor = new MVELExpressionExecutor(this.parserConfiguration);
        this.loadGlobalFunctions();
        this.createStaticContext();
    }

    protected void createStaticContext() {
        this.staticContext = new StaticVariableResolverFactory(this.parserConfiguration, this.muleContext);
        this.globalContext = new GlobalVariableResolverFactory(this.getAliases(), this.getGlobalFunctions(), this.parserConfiguration, this.muleContext);
    }

    protected void loadGlobalFunctions() throws InitialisationException {
        if (this.globalFunctionsFile != null) {
            try {
                this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((CompiledExpression)new ExpressionCompiler(IOUtils.getResourceAsString(this.globalFunctionsFile, this.getClass())).compile()));
            }
            catch (IOException e) {
                throw new InitialisationException(CoreMessages.failedToLoad(this.globalFunctionsFile), (Throwable)e, this);
            }
        }
        this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((CompiledExpression)new ExpressionCompiler(this.globalFunctionsString).compile()));
    }

    @Override
    public <T> T evaluate(String expression) {
        return this.evaluate(expression, (Map<String, Object>)null);
    }

    @Override
    public <T> T evaluate(String expression, Map<String, Object> vars) {
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        if (vars != null) {
            context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars, (VariableResolverFactory)new DelegateVariableResolverFactory(this.staticContext, this.globalContext)));
        } else {
            context.setNextFactory(new DelegateVariableResolverFactory(this.staticContext, this.globalContext));
        }
        return this.evaluateInternal(expression, context);
    }

    @Override
    public <T> T evaluate(String expression, MuleEvent event) {
        return this.evaluate(expression, event, null);
    }

    @Override
    public <T> T evaluate(String expression, MuleEvent event, Map<String, Object> vars) {
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        if (vars != null) {
            context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars, (VariableResolverFactory)new DelegateVariableResolverFactory(this.staticContext, (VariableResolverFactory)new EventVariableResolverFactory(this.parserConfiguration, this.muleContext, event, (VariableResolverFactory)new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(event))))));
        } else {
            context.setNextFactory(new DelegateVariableResolverFactory(this.staticContext, (VariableResolverFactory)new EventVariableResolverFactory(this.parserConfiguration, this.muleContext, event, (VariableResolverFactory)new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(event)))));
        }
        return this.evaluateInternal(expression, context);
    }

    @Override
    @Deprecated
    public <T> T evaluate(String expression, MuleMessage message) {
        return this.evaluate(expression, message, null);
    }

    @Override
    @Deprecated
    public <T> T evaluate(String expression, MuleMessage message, Map<String, Object> vars) {
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        if (vars != null) {
            context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars, (VariableResolverFactory)new DelegateVariableResolverFactory(this.staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(this.parserConfiguration, this.muleContext, message, new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(message))))));
        } else {
            context.setNextFactory(new DelegateVariableResolverFactory(this.staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(this.parserConfiguration, this.muleContext, message, new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(message)))));
        }
        return this.evaluateInternal(expression, context);
    }

    protected <T> T evaluateInternal(String expression, MVELExpressionLanguageContext variableResolverFactory) {
        this.validate(expression);
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            return (T)this.expressionExecutor.execute(expression, variableResolverFactory);
        }
        catch (Exception e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(expression), (Throwable)e);
        }
    }

    @Override
    public boolean isValid(String expression) {
        try {
            this.validate(expression);
            return true;
        }
        catch (InvalidExpressionException e) {
            return false;
        }
    }

    @Override
    public void validate(String expression) throws InvalidExpressionException {
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                throw new InvalidExpressionException(expression, "Expression string is not an expression");
            }
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            this.expressionExecutor.validate(expression);
        }
        catch (CompileException e) {
            throw new InvalidExpressionException(expression, e.getMessage());
        }
    }

    protected MVELExpressionLanguageContext createExpressionLanguageContext() {
        return new MVELExpressionLanguageContext(this.parserConfiguration, this.muleContext);
    }

    protected ParserConfiguration createParserConfiguration() {
        ParserConfiguration ParserConfiguration2 = new ParserConfiguration();
        this.configureParserConfiguration(ParserConfiguration2);
        return ParserConfiguration2;
    }

    protected void configureParserConfiguration(ParserConfiguration parserConfiguration) {
        parserConfiguration.addPackageImport("java.io");
        parserConfiguration.addPackageImport("java.lang");
        parserConfiguration.addPackageImport("java.net");
        parserConfiguration.addPackageImport("java.util");
        parserConfiguration.addImport(BigDecimal.class);
        parserConfiguration.addImport(BigInteger.class);
        parserConfiguration.addImport(DataHandler.class);
        parserConfiguration.addImport(MimeType.class);
        parserConfiguration.addImport(Pattern.class);
        parserConfiguration.addImport(DataType.class);
        parserConfiguration.addImport(DataTypeFactory.class);
        parserConfiguration.addImport(NullPayload.class);
        for (Map.Entry<String, Class<?>> importEntry : this.imports.entrySet()) {
            parserConfiguration.addImport(importEntry.getKey(), importEntry.getValue());
        }
    }

    public void setGlobalFunctionsString(String globalFunctionsString) {
        this.globalFunctionsString = globalFunctionsString;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void setImports(Map<String, Class<?>> imports) {
        this.imports = imports;
    }

    public void setAutoResolveVariables(boolean autoResolveVariables) {
        this.autoResolveVariables = autoResolveVariables;
    }

    public void addGlobalFunction(String name, Function function) {
        this.globalFunctions.put(name, function);
    }

    public void addImport(String name, Class<?> clazz) {
        this.imports.put(name, clazz);
    }

    public void addAlias(String name, String expression) {
        this.aliases.put(name, expression);
    }

    public void setGlobalFunctionsFile(String globalFunctionsFile) {
        this.globalFunctionsFile = globalFunctionsFile;
    }

    protected VariableResolverFactory createVariableVariableResolverFactory(MuleEvent event) {
        if (this.autoResolveVariables) {
            return new VariableVariableResolverFactory(this.parserConfiguration, this.muleContext, event);
        }
        return new NullVariableResolverFactory();
    }

    @Deprecated
    protected VariableResolverFactory createVariableVariableResolverFactory(MuleMessage message) {
        if (this.autoResolveVariables) {
            return new VariableVariableResolverFactory(this.parserConfiguration, this.muleContext, message);
        }
        return new NullVariableResolverFactory();
    }

    protected Map<String, String> getAliases() {
        return this.aliases;
    }

    protected Map<String, Function> getGlobalFunctions() {
        return this.globalFunctions;
    }
}

