/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.security.SecurityContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.UUID;

public final class DefaultMuleSession
implements MuleSession {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog(DefaultMuleSession.class);
    private boolean valid = true;
    private String id;
    private SecurityContext securityContext;
    private Map<String, Object> properties;
    @Deprecated
    private FlowConstruct flowConstruct;

    public DefaultMuleSession() {
        this.id = UUID.getUUID();
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
    }

    public DefaultMuleSession(MuleSession session) {
        this.id = session.getId();
        this.securityContext = session.getSecurityContext();
        this.valid = session.isValid();
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
        for (String key : session.getPropertyNamesAsSet()) {
            this.properties.put(key, session.getProperty(key));
        }
    }

    @Deprecated
    public DefaultMuleSession(MuleContext muleContext) {
        this();
    }

    @Deprecated
    public DefaultMuleSession(FlowConstruct flowConstruct, MuleContext muleContext) {
        this();
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleSession source, MuleContext muleContext) {
        this(source);
    }

    @Deprecated
    public DefaultMuleSession(MuleSession source, FlowConstruct flowConstruct) {
        this(source);
        this.flowConstruct = flowConstruct;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean value) {
        this.valid = value;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (!(value instanceof Serializable)) {
            logger.warn((Object)CoreMessages.sessionPropertyNotSerializableWarning(key));
        }
        this.properties.put(key, value);
    }

    @Override
    public <T> T getProperty(Object key) {
        return (T)this.properties.get(key);
    }

    @Override
    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    @Override
    @Deprecated
    public Iterator<String> getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public Set<String> getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void merge(MuleSession updatedSession) {
        if (updatedSession == null) {
            return;
        }
        Map<String, Object> oldProperties = this.properties;
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
        for (String string : updatedSession.getPropertyNamesAsSet()) {
            this.properties.put(string, updatedSession.getProperty(string));
        }
        for (Map.Entry entry : oldProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey()) || oldProperties.get(entry.getKey()) instanceof Serializable) continue;
            this.properties.put((String)entry.getKey(), oldProperties.get(entry.getKey()));
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    void removeNonSerializableProperties() {
        Iterator<Map.Entry<String, Object>> propertyIterator = this.properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, Object> entry = propertyIterator.next();
            if (entry.getValue() instanceof Serializable) continue;
            logger.warn((Object)CoreMessages.propertyNotSerializableWasDropped(entry.getKey()));
            propertyIterator.remove();
        }
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.setProperty(key, (Object)value);
    }

    @Override
    public <T> T getProperty(String key) {
        return this.getProperty((Object)key);
    }

    @Override
    public Object removeProperty(String key) {
        return this.removeProperty((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        DefaultMuleSession copy = new DefaultMuleSession(this);
        copy.removeNonSerializableProperties();
        Map<String, Object> backupProperties = this.properties;
        try {
            this.properties = copy.properties;
            out.defaultWriteObject();
        }
        finally {
            this.properties = backupProperties;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

