/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.service;

import java.util.Map;
import java.util.Properties;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.DefaultTransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.PropertiesUtils;
import org.mule.util.SpiUtils;

public class MetaTransportServiceDescriptor
extends DefaultTransportServiceDescriptor {
    private String metaScheme;

    public MetaTransportServiceDescriptor(String metaScheme, String scheme, Properties props, ClassLoader classLoader) throws ServiceException {
        super(metaScheme, props, classLoader);
        this.metaScheme = metaScheme;
        Properties p = SpiUtils.findServiceDescriptor(ServiceType.TRANSPORT, scheme);
        if (p == null) {
            throw new ServiceException(CoreMessages.failedToCreate("transport: " + metaScheme + ":" + scheme));
        }
        Properties temp = new Properties();
        PropertiesUtils.getPropertiesWithPrefix(props, scheme + ".", temp);
        if (temp.size() > 0) {
            p.putAll((Map<?, ?>)PropertiesUtils.removeNamespaces(temp));
        }
        this.setOverrides(p);
    }

    @Override
    public Connector createConnector() throws TransportServiceException {
        AbstractConnector c = (AbstractConnector)super.createConnector();
        c.registerSupportedMetaProtocol(this.metaScheme);
        return c;
    }
}

