/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.mule.util.scan.ClassScanner;
import org.mule.util.scan.annotations.ClosableClassReader;
import org.objectweb.asm.commons.EmptyVisitor;

public class InterfaceClassScanner
extends EmptyVisitor
implements ClassScanner {
    private Class interfaceClass;
    private boolean match;
    private String className;
    private ClassLoader classLoader;

    public InterfaceClassScanner(Class interfaceClass) {
        this(interfaceClass, Thread.currentThread().getContextClassLoader());
    }

    public InterfaceClassScanner(Class interfaceClass, ClassLoader classLoader) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("The class need to be an interface");
        }
        this.interfaceClass = interfaceClass;
        this.classLoader = classLoader;
    }

    public void visit(int i, int i1, String s, String s1, String superName, String[] interfaces) {
        if (interfaces != null && interfaces.length > 0) {
            for (int j = 0; j < interfaces.length; ++j) {
                String anInterface = interfaces[j].replace("/", ".");
                if (this.interfaceClass.getName().equals(anInterface)) {
                    this.match = true;
                    this.className = s;
                    break;
                }
                ClassScanner scanner = this.scan(anInterface);
                this.match = scanner.isMatch();
                this.className = s;
            }
        } else {
            if (superName == null) {
                return;
            }
            ClassScanner scanner = this.scan(superName);
            this.match = scanner.isMatch();
            this.className = scanner.getClassName();
            if (this.match) {
                this.className = s;
            }
        }
    }

    protected ClassScanner scan(String name) {
        try {
            InterfaceClassScanner scanner = new InterfaceClassScanner(this.interfaceClass, this.classLoader);
            URL classURL = this.getClassURL(name);
            if (classURL == null) {
                throw new RuntimeException("Failed to read class URL for name: " + name);
            }
            InputStream classStream = classURL.openStream();
            ClosableClassReader r = new ClosableClassReader(classStream);
            r.accept(scanner, 0);
            return scanner;
        }
        catch (IOException e) {
            throw new RuntimeException(name, e);
        }
    }

    @Override
    public boolean isMatch() {
        return this.match;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public URL getClassURL(String className) {
        String resource = className.replace(".", "/") + ".class";
        return this.classLoader.getResource(resource);
    }
}

