/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.registry.ServiceType;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.util.StreamCloserService;
import org.mule.config.ClusterConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.registry.MuleRegistryHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.PollingController;
import org.mule.util.store.MuleObjectStoreManager;

public class DefaultMuleContextTestCase
extends AbstractMuleTestCase {
    public static final String INITIAL_VALUE = "500";
    public static final String VALUE_AFTER_REDEPLOY = "222";
    public static final String TEST_PROTOCOL = "test2";
    private SystemExceptionHandler mockSystemExceptionHandler = (SystemExceptionHandler)Mockito.mock(SystemExceptionHandler.class);
    private MessagingException mockMessagingException = (MessagingException)((Object)Mockito.mock(MessagingException.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearExceptionHelperCacheForAppWhenDispose() throws Exception {
        MuleContext ctx = new DefaultMuleContextFactory().createMuleContext();
        String value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)INITIAL_VALUE));
        ctx.dispose();
        URL url = DefaultMuleContextTestCase.class.getClassLoader().getResource("META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/" + TEST_PROTOCOL + "-exception-mappings.properties");
        File exceptionMappingFile = new File(url.getFile());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(exceptionMappingFile);
            fileWriter.append("\njava.lang.IllegalArgumentException=222");
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        ctx = new DefaultMuleContextFactory().createMuleContext();
        ctx.setExecutionClassLoader(this.getClass().getClassLoader());
        value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)VALUE_AFTER_REDEPLOY));
    }

    @Test
    public void callSystemExceptionHandlerWhenExceptionIsMessagingException() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.setExceptionListener(this.mockSystemExceptionHandler);
        context.handleException((Exception)((Object)this.mockMessagingException));
        ((SystemExceptionHandler)Mockito.verify((Object)this.mockSystemExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)1))).handleException((Exception)((Object)this.mockMessagingException), null);
    }

    @Test
    public void getObjectStoreManager() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        ObjectStoreManager osManager = context.getObjectStoreManager();
        junit.framework.Assert.assertTrue((boolean)(osManager instanceof MuleObjectStoreManager));
    }

    @Test
    public void defaultMuleClusterConfiguration() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.start();
        Assert.assertThat((Object)context.getClusterId(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)context.getClusterNodeId(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void overriddenClusterConfiguration() throws Exception {
        int clusterNodeId = 22;
        String clusterId = "some-id";
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.getRegistry().registerObject("_muleClusterConfiguration", (Object)new ClusterConfiguration(){

            public String getClusterId() {
                return "some-id";
            }

            public int getClusterNodeId() {
                return 22;
            }
        });
        context.start();
        Assert.assertThat((Object)context.getClusterId(), (Matcher)Is.is((Object)"some-id"));
        Assert.assertThat((Object)context.getClusterNodeId(), (Matcher)Is.is((Object)22));
    }

    @Test
    public void defaultMulePollingController() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.start();
        Assert.assertThat((Object)context.isPrimaryPollingInstance(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void overriddenMulePollingController() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.getRegistry().registerObject("_mulePollingController", (Object)new PollingController(){

            public boolean isPrimaryPollingInstance() {
                return false;
            }
        });
        context.start();
        Assert.assertThat((Object)context.isPrimaryPollingInstance(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void getStreamCloserService() throws Exception {
        DefaultMuleContext context = (DefaultMuleContext)new DefaultMuleContextFactory().createMuleContext();
        StreamCloserService serviceFromRegistry = (StreamCloserService)context.getRegistry().lookupObject("_muleStreamCloserService");
        MuleRegistryHelper registry = (MuleRegistryHelper)Mockito.spy((Object)((MuleRegistryHelper)context.getRegistry()));
        context.setMuleRegistry(registry);
        StreamCloserService streamCloserService = context.getStreamCloserService();
        Assert.assertNotNull((Object)streamCloserService);
        Assert.assertSame((Object)serviceFromRegistry, (Object)streamCloserService);
        Assert.assertSame((Object)streamCloserService, (Object)context.getStreamCloserService());
        ((MuleRegistryHelper)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)1))).lookupObject("_muleStreamCloserService");
    }
}

