/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.expression.ExpressionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.AttributeEvaluator;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AttributeEvaluatorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExpressionManager mockExpressionManager;

    @Test
    public void testPlainTextValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("attributeEvaluator");
        Mockito.when((Object)this.mockExpressionManager.isExpression("attributeEvaluator")).thenReturn((Object)false);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testExpressionValue() {
        String attributeValue = "#[eval:express]";
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExpressionValueNoEvaluator() {
        String attributeValue = "#[express]";
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParse() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("1#[2]3#[4]5");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParseStartsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[1]234#[5]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParseStartsAndEndsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[1]#[2]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParenthesesInExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[(1)]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isString(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }
}

