/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.queue.LocalQueueTxJournalEntry;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.QueueStore;

public class LocalTxQueueTransactionJournalTestCase
extends AbstractMuleContextTestCase {
    public static final int TX_ID = 1;
    public static final String QUEUE_NAME = "queueName";
    public static final String SOME_VALUE = "some value";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DefaultQueueStore mockQueueInfo = (DefaultQueueStore)Mockito.mock(DefaultQueueStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUpMocks() {
        Mockito.when((Object)this.mockQueueInfo.getName()).thenReturn((Object)QUEUE_NAME);
    }

    @Test
    public void logAddAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry logEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)logEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)logEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)logEntry.isAdd(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logAddFirstAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAddFirst((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAddFirst(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logRemoveAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRemove((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isRemove(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logCommitAndRetrieve() {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logCommit((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void logRollbackAndRetrieve() {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRollback((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void logSeveralAddsThenCommitAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.logCommit((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1001));
    }

    @Test
    public void logSeveralAddsAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)numberOfOffers));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)numberOfOffers));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAdd(), (Matcher)Is.is((Object)true));
    }
}

