/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.util;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SystemPropertyInitializingBean
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Map<String, String> systemProperties;

    public void afterPropertiesSet() throws Exception {
        if (this.systemProperties == null || this.systemProperties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            String key = entry.getKey();
            String value = this.systemProperties.get(key);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Setting system property: %s=%s", key, value));
            }
            System.setProperty(key, value);
        }
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }
}

