/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import org.mvel2.CompileException;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.LineLabel;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.DebuggerContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.PropertyTools;

public class MVELRuntime {
    public static final ImmutableDefaultFactory IMMUTABLE_DEFAULT_FACTORY = new ImmutableDefaultFactory();
    private static ThreadLocal<DebuggerContext> debuggerContext;

    public static Object execute(boolean debugger, CompiledExpression expression, Object ctx, VariableResolverFactory variableFactory) {
        ExecutionStack stk = new ExecutionStack();
        ASTNode tk = expression.getFirstNode();
        if (tk == null) {
            return null;
        }
        try {
            block14: do {
                if (tk.fields == -1) {
                    if (!debugger && !(debugger = MVELRuntime.hasDebuggerContext())) continue;
                    try {
                        debuggerContext.get().checkBreak((LineLabel)tk, variableFactory, expression);
                    }
                    catch (NullPointerException e) {}
                    continue;
                }
                if (stk.isEmpty()) {
                    stk.push(tk.getReducedValueAccelerated(ctx, ctx, variableFactory));
                }
                Integer operator = tk.getOperator();
                switch (operator) {
                    case -1: {
                        break;
                    }
                    case 29: {
                        if (!stk.popBoolean().booleanValue()) {
                            while (tk.nextASTNode != null && !(tk = tk.nextASTNode).isOperator(30)) {
                            }
                        }
                        stk.clear();
                        break;
                    }
                    case 30: {
                        return stk.pop();
                    }
                    case 37: {
                        if (tk.nextASTNode == null) continue block14;
                        stk.clear();
                        break;
                    }
                    default: {
                        stk.push(tk.nextASTNode.getReducedValueAccelerated(ctx, ctx, variableFactory), operator);
                        try {
                            while (stk.isReduceable()) {
                                if ((Integer)stk.pop() != 23) continue;
                                Object v1 = stk.pop();
                                Object v2 = stk.pop();
                                if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                                    stk.clear();
                                    stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                                    continue;
                                }
                                stk.push(null);
                            }
                            continue block14;
                        }
                        catch (ClassCastException e) {
                            throw new CompileException("syntax error or incomptable types", e);
                        }
                        catch (CompileException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CompileException("failed to compile sub expression", e);
                        }
                    }
                }
            } while ((tk = tk.nextASTNode) != null);
            return stk.peek();
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator() && tk.nextASTNode != null) {
                throw new CompileException("incomplete statement: " + tk.getName() + " (possible use of reserved keyword as identifier: " + tk.getName() + ")");
            }
            throw e;
        }
    }

    public static void registerBreakpoint(String source, int line) {
        MVELRuntime.ensureDebuggerContext();
        debuggerContext.get().registerBreakpoint(source, line);
    }

    public static void removeBreakpoint(String source, int line) {
        if (MVELRuntime.hasDebuggerContext()) {
            debuggerContext.get().removeBreakpoint(source, line);
        }
    }

    private static boolean hasDebuggerContext() {
        return debuggerContext != null && debuggerContext.get() != null;
    }

    private static void ensureDebuggerContext() {
        if (debuggerContext == null) {
            debuggerContext = new ThreadLocal();
        }
        if (debuggerContext.get() == null) {
            debuggerContext.set(new DebuggerContext());
        }
    }

    public static void clearAllBreakpoints() {
        if (MVELRuntime.hasDebuggerContext()) {
            debuggerContext.get().clearAllBreakpoints();
        }
    }

    public static boolean hasBreakpoints() {
        return MVELRuntime.hasDebuggerContext() && debuggerContext.get().hasBreakpoints();
    }

    public static void setThreadDebugger(Debugger debugger) {
        MVELRuntime.ensureDebuggerContext();
        debuggerContext.get().setDebugger(debugger);
    }

    public static void resetDebugger() {
        debuggerContext = null;
    }
}

