/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.db.internal.config.processor;

import org.mule.module.db.internal.config.domain.query.ParameterizedQueryDefinitionParser;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.ColumnIndexAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.ColumnNameAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.DefaultAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.util.StringUtils;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractAdvancedDbProcessorDefinitionParser extends AbstractDbProcessorDefinitionParser
{

    public static final String AUTO_GENERATED_KEYS_PROPERTY = "autoGeneratedKeys";
    public static final String COLUMN_INDEXES_PROPERTY = "autoGeneratedKeysColumnIndexes";
    public static final String COLUMN_NAMES_PROPERTY = "autoGeneratedKeysColumnNames";
    public static final String QUERY_METADATA_PROVIDER_PROPERTY = "queryMetadataProvider";
    public static final String TRANSACTIONAL_ACTION_PROPERTY = "transactionalAction";
    public static final String AUTO_GENERATED_KEY_STRATEGY_PROPERTY = "autoGeneratedKeyStrategy";

    protected final ParameterizedQueryDefinitionParser parameterizedQueryDefinitionParser = new ParameterizedQueryDefinitionParser();
    protected AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;

    protected abstract Object createExecutorFactory(Element element);

    protected abstract Object getMetadataProvider();

    protected void parseExecutorFactory(Element element, BeanDefinitionBuilder builder)
    {
        builder.addConstructorArgValue(createExecutorFactory(element));
    }

    protected void parseTransactionalAction(Element element, BeanDefinitionBuilder builder)
    {
        builder.addConstructorArgValue(TransactionalAction.valueOf(element.getAttribute(TRANSACTIONAL_ACTION_PROPERTY)));
    }

    protected void parseAutoGeneratedKeys(Element element, BeanDefinitionBuilder builder)
    {
        boolean autoGeneratedKeysAttribute = false;
        if (element.hasAttribute(AUTO_GENERATED_KEYS_PROPERTY))
        {
            autoGeneratedKeysAttribute = Boolean.parseBoolean(element.getAttribute(AUTO_GENERATED_KEYS_PROPERTY));
        }

        if (autoGeneratedKeysAttribute)
        {
            String columnIndexesAttribute = null;
            if (element.hasAttribute(COLUMN_INDEXES_PROPERTY))
            {
                columnIndexesAttribute = element.getAttribute(COLUMN_INDEXES_PROPERTY);
            }

            String columnNamesAttribute = null;
            if (element.hasAttribute(COLUMN_NAMES_PROPERTY))
            {
                columnNamesAttribute = element.getAttribute(COLUMN_NAMES_PROPERTY);
            }

            if (!StringUtils.isEmpty(columnIndexesAttribute))
            {
                int[] columnIndexes = new int[columnIndexesAttribute.length()];
                int i = 0;
                for (String stringIndex : columnIndexesAttribute.split(LIST_SEPARATOR))
                {
                    columnIndexes[i++] = Integer.parseInt(stringIndex);
                }
                autoGeneratedKeyStrategy = new ColumnIndexAutoGeneratedKeyStrategy(columnIndexes);
            }
            else if (!StringUtils.isEmpty(columnNamesAttribute))
            {
                String[] columnNames = columnNamesAttribute.split(LIST_SEPARATOR);
                autoGeneratedKeyStrategy = new ColumnNameAutoGeneratedKeyStrategy(columnNames);
            }
            else
            {
                autoGeneratedKeyStrategy = new DefaultAutoGeneratedKeyStrategy();
            }
        }
        else
        {
            autoGeneratedKeyStrategy = new NoAutoGeneratedKeyStrategy();
        }

        builder.getBeanDefinition().getPropertyValues().add(AUTO_GENERATED_KEY_STRATEGY_PROPERTY, autoGeneratedKeyStrategy);
    }

    protected void parseMetadataProvider(Element element, BeanDefinitionBuilder builder)
    {
        if (!(element.hasAttribute(QUERY_METADATA_PROVIDER_PROPERTY)))
        {
            builder.addPropertyValue(QUERY_METADATA_PROVIDER_PROPERTY, getMetadataProvider());
        }
    }

}
