/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.activity.SubProcessActivity;
import org.jbpm.jpdl.internal.activity.SubProcessInParameterImpl;
import org.jbpm.jpdl.internal.activity.SubProcessOutParameterImpl;
import org.jbpm.jpdl.internal.activity.SubProcessParameterImpl;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessBinding
extends JpdlBinding {
    public SubProcessBinding() {
        super("sub-process");
    }

    @Override
    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        SubProcessActivity subProcessActivity = new SubProcessActivity();
        String subProcessKey = XmlUtil.attribute((Element)element, (String)"sub-process-key");
        subProcessActivity.setSubProcessKey(subProcessKey);
        String subProcessId = XmlUtil.attribute((Element)element, (String)"sub-process-id");
        subProcessActivity.setSubProcessId(subProcessId);
        ArrayList<SubProcessInParameterImpl> inParameters = new ArrayList<SubProcessInParameterImpl>();
        for (Element inElement : XmlUtil.elements((Element)element, (String)"parameter-in")) {
            SubProcessInParameterImpl inParameter = new SubProcessInParameterImpl();
            this.parseParameter(inElement, inParameter);
            inParameters.add(inParameter);
            if (inParameter.getSubVariableName() == null) {
                parse.addProblem("no 'subvar' specified for parameter-in", element);
            }
            if (inParameter.getExpression() == null && inParameter.getVariableName() == null) {
                parse.addProblem("no 'expr' or 'variable' specified for parameter-in '" + inParameter.getSubVariableName() + "'", element);
            }
            if (inParameter.getExpression() == null || inParameter.getVariableName() == null) continue;
            parse.addProblem("attributes 'expr' and 'variable' are mutually exclusive on parameter-in", element);
        }
        subProcessActivity.setInParameters(inParameters);
        ArrayList<SubProcessOutParameterImpl> outParameters = new ArrayList<SubProcessOutParameterImpl>();
        for (Element outElement : XmlUtil.elements((Element)element, (String)"parameter-out")) {
            SubProcessOutParameterImpl outParameter = new SubProcessOutParameterImpl();
            this.parseParameter(outElement, outParameter);
            outParameters.add(outParameter);
            if (outParameter.getVariableName() == null) {
                parse.addProblem("no 'variable' specified for parameter-in", element);
            }
            if (outParameter.getExpression() == null && outParameter.getSubVariableName() == null) {
                parse.addProblem("no 'expr' or 'subvar' specified for parameter-out '" + outParameter.getVariableName() + "'", element);
            }
            if (outParameter.getExpression() == null || outParameter.getSubVariableName() == null) continue;
            parse.addProblem("attributes 'expr' and 'subvar' are mutually exclusive on parameter-out '" + outParameter.getVariableName() + "'", element);
        }
        subProcessActivity.setOutParameters(outParameters);
        Map<String, String> swimlaneMappings = SubProcessBinding.parseSwimlaneMappings(element, parse);
        subProcessActivity.setSwimlaneMappings(swimlaneMappings);
        HashMap<Object, String> outcomeVariableMappings = new HashMap<Object, String>();
        String outcomeExpressionText = XmlUtil.attribute((Element)element, (String)"outcome");
        String outcomeLanguage = XmlUtil.attribute((Element)element, (String)"outcome-lang");
        if (outcomeExpressionText != null) {
            Expression outcomeExpression = Expression.create((String)outcomeExpressionText, (String)outcomeLanguage);
            subProcessActivity.setOutcomeExpression(outcomeExpression);
            for (Element transitionElement : XmlUtil.elements((Element)element, (String)"transition")) {
                Element valueElement;
                Element outcomeValueElement = XmlUtil.element((Element)transitionElement, (String)"outcome-value");
                if (outcomeValueElement == null) continue;
                String transitionName = XmlUtil.attribute((Element)transitionElement, (String)"name");
                if (transitionName == null) {
                    parse.addProblem("transitions with an outcome-value must have a name", transitionElement);
                }
                if ((valueElement = XmlUtil.element((Element)outcomeValueElement)) != null) {
                    Descriptor descriptor = (Descriptor)WireParser.getInstance().parseElement(valueElement, parse);
                    Object value = WireContext.create((Descriptor)descriptor);
                    outcomeVariableMappings.put(value, transitionName);
                    subProcessActivity.setOutcomeVariableMappings(outcomeVariableMappings);
                    continue;
                }
                parse.addProblem("outcome-value must contain exactly one element", outcomeValueElement);
            }
        }
        return subProcessActivity;
    }

    void parseParameter(Element element, SubProcessParameterImpl parameter) {
        String variable;
        String name = XmlUtil.attribute((Element)element, (String)"subvar");
        parameter.setSubVariableName(name);
        String expressionText = XmlUtil.attribute((Element)element, (String)"expr");
        String language = XmlUtil.attribute((Element)element, (String)"expr-lang");
        if (expressionText != null) {
            Expression expression = Expression.create((String)expressionText, (String)language);
            parameter.setExpression(expression);
        }
        if ((variable = XmlUtil.attribute((Element)element, (String)"var")) != null) {
            parameter.setVariableName(variable);
        }
    }

    public static Map<String, String> parseSwimlaneMappings(Element element, Parse parse) {
        HashMap<String, String> swimlaneMappings = new HashMap<String, String>();
        for (Element inElement : XmlUtil.elements((Element)element, (String)"swimlane-mapping")) {
            String swimlane = XmlUtil.attribute((Element)inElement, (String)"swimlane", (Parse)parse);
            String subSwimlane = XmlUtil.attribute((Element)inElement, (String)"sub-swimlane", (Parse)parse);
            swimlaneMappings.put(swimlane, subSwimlane);
        }
        return swimlaneMappings;
    }
}

