/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.identity.impl.IdentitySessionResource;
import org.jbpm.pvm.internal.identity.impl.JBossIdmIdentitySessionImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;
import org.jbpm.pvm.internal.tx.StandardTransaction;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.common.exception.IdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbossIdmIdentitySessionDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    protected String realmName;

    @Override
    public Object construct(WireContext wireContext) {
        IdentitySessionFactory identitySessionFactory = EnvironmentImpl.getFromCurrent(IdentitySessionFactory.class);
        try {
            org.picketlink.idm.api.IdentitySession identitySession = identitySessionFactory.createIdentitySession(this.realmName);
            EnvironmentImpl environment = EnvironmentImpl.getCurrent();
            StandardTransaction transaction = environment.get(StandardTransaction.class);
            if (transaction != null) {
                IdentitySessionResource identitySessionResource = new IdentitySessionResource(identitySession);
                transaction.enlistResource(identitySessionResource);
            }
            return new JBossIdmIdentitySessionImpl(identitySession);
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't create the identity session for realm [" + this.realmName + "]");
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return IdentitySession.class;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

