/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsTopicResolver;
import org.mule.util.MapUtils;
import org.mule.util.StringMessageUtils;

public class DefaultJmsTopicResolver
implements JmsTopicResolver {
    protected static final Log logger = LogFactory.getLog(DefaultJmsTopicResolver.class);
    private JmsConnector connector;

    public DefaultJmsTopicResolver(JmsConnector connector) {
        this.connector = connector;
    }

    public JmsConnector getConnector() {
        return this.connector;
    }

    @Override
    public boolean isTopic(ImmutableEndpoint endpoint) {
        return this.isTopic(endpoint, true);
    }

    @Override
    public boolean isTopic(ImmutableEndpoint endpoint, boolean fallbackToEndpointProperties) {
        boolean topic;
        String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
        boolean bl = topic = "topic".equalsIgnoreCase(resourceInfo) || endpoint.getEndpointURI().toString().contains("topic:");
        if (!topic && fallbackToEndpointProperties) {
            topic = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"topic", (boolean)false);
        }
        return topic;
    }

    @Override
    public boolean isTopic(Destination destination) {
        this.checkInvariants(destination);
        return destination instanceof Topic;
    }

    protected void checkInvariants(Destination destination) {
        if (destination instanceof Topic && destination instanceof Queue && this.connector.getJmsSupport() instanceof Jms102bSupport) {
            logger.error((Object)StringMessageUtils.getBoilerPlate((String)"Destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://www.mulesoft.org/jira"));
        }
    }
}

