/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.activemq;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.mule.api.MuleContext;
import org.mule.api.transport.Connectable;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsConnector;
import org.mule.util.ClassUtils;
import org.mule.util.proxy.TargetInvocationHandler;

public class ActiveMQJmsConnector
extends JmsConnector {
    public static final String ACTIVEMQ_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQConnectionFactory";
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";
    private String brokerURL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public ActiveMQJmsConnector(MuleContext context) {
        super(context);
        this.setEagerConsumer(false);
    }

    @Override
    protected ConnectionFactory getDefaultConnectionFactory() throws Exception {
        ConnectionFactory connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass((String)ACTIVEMQ_CONNECTION_FACTORY_CLASS, (Object[])new Object[]{this.getBrokerURL()});
        this.applyVendorSpecificConnectionFactoryProperties(connectionFactory);
        return connectionFactory;
    }

    protected void applyVendorSpecificConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        try {
            Method getRedeliveryPolicyMethod = connectionFactory.getClass().getMethod("getRedeliveryPolicy", new Class[0]);
            Object redeliveryPolicy = getRedeliveryPolicyMethod.invoke((Object)connectionFactory, new Object[0]);
            Method setMaximumRedeliveriesMethod = redeliveryPolicy.getClass().getMethod("setMaximumRedeliveries", Integer.TYPE);
            int maxRedelivery = this.getMaxRedelivery();
            if (maxRedelivery != -1) {
                ++maxRedelivery;
            }
            setMaximumRedeliveriesMethod.invoke(redeliveryPolicy, maxRedelivery);
        }
        catch (Exception e) {
            this.logger.error((Object)("Can not set MaxRedelivery parameter to RedeliveryPolicy " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDisconnect() throws Exception {
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            Class<?> clazz = connection.getClass();
            Method cleanupMethod = null;
            if (Proxy.isProxyClass(clazz)) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(connection);
                if (invocationHandler instanceof TargetInvocationHandler) {
                    TargetInvocationHandler targetInvocationHandler = (TargetInvocationHandler)invocationHandler;
                    connection = (Connection)targetInvocationHandler.getTargetObject();
                    Class<?> realConnectionClass = connection.getClass();
                    cleanupMethod = realConnectionClass.getMethod("cleanup", null);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("InvocationHandler of the JMS connection proxy is of type %s, not doing any extra cleanup", invocationHandler.getClass().getName()));
                }
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            try {
                if (cleanupMethod != null) {
                    cleanupMethod.invoke((Object)connection, (Object[])null);
                }
            }
            catch (InvocationTargetException ex) {
                this.logger.warn((Object)("Exception cleaning up JMS connection: " + ex.getMessage()));
            }
            finally {
                try {
                    connection.close();
                }
                catch (JMSException ex) {
                    this.logger.warn((Object)("Exception closing JMS connection: " + ex.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
        finally {
            this.setConnection(null);
        }
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }
}

