/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.mule.DefaultMuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;

public class FtpMuleMessageFactory
extends AbstractMuleMessageFactory {
    private FTPClient ftpClient;
    private boolean streaming;

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        FTPFile file = (FTPFile)transportMessage;
        if (this.streaming) {
            InputStream stream = this.ftpClient.retrieveFileStream(file.getName());
            if (stream == null) {
                throw new IOException(MessageFormat.format("Failed to retrieve file {0}. Ftp error: {1}", file.getName(), this.ftpClient.getReplyCode()));
            }
            return stream;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!this.ftpClient.retrieveFile(file.getName(), (OutputStream)baos)) {
                throw new IOException(String.format("Failed to retrieve file %s. Ftp error: %s", file.getName(), this.ftpClient.getReplyCode()));
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to retrieve file %s due to unexpected exception", file.getName()), e);
        }
        catch (OutOfMemoryError e) {
            throw new IOException(String.format("Failed to retrieve file %s because it's larger than the current memory heap. Consider enabling streaming on the FTP connector", file.getName()), e);
        }
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{FTPFile.class};
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        FTPFile file = (FTPFile)transportMessage;
        message.setInboundProperty("originalFilename", (Object)file.getName());
        message.setInboundProperty("fileSize", (Object)file.getSize());
        message.setInboundProperty("timestamp", (Object)file.getTimestamp());
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }
}

