/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIStaxInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_GET_SUPPORTED = "org.apache.cxf.fastinfoset.get.supported";

    public FIStaxInInterceptor() {
        this("post-stream");
    }

    public FIStaxInInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxInInterceptor.class.getName());
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }

    private StAXDocumentParser getParser(InputStream in) {
        StAXDocumentParser parser = new StAXDocumentParser(in);
        parser.setStringInterning(true);
        parser.setForceStreamClose(true);
        parser.setInputStream(in);
        return parser;
    }

    public void handleMessage(Message message) {
        if (message.getContent(XMLStreamReader.class) != null || !this.isHttpVerbSupported(message)) {
            return;
        }
        String ct = (String)message.get((Object)"Content-Type");
        if (ct != null && ct.indexOf("fastinfoset") != -1 && message.getContent(InputStream.class) != null && message.getContent(XMLStreamReader.class) == null) {
            message.setContent(XMLStreamReader.class, (Object)this.getParser((InputStream)message.getContent(InputStream.class)));
            message.getInterceptorChain().add((Interceptor)StaxInEndingInterceptor.INSTANCE);
            ct = ct.replace("fastinfoset", "xml");
            if (ct.contains("application/xml")) {
                ct = ct.replace("application/xml", "text/xml");
            }
            message.put((Object)"Content-Type", (Object)ct);
            message.getExchange().put((Object)"org.apache.cxf.fastinfoset.enabled", (Object)Boolean.TRUE);
            if (this.isRequestor(message)) {
                Endpoint ep = message.getExchange().getEndpoint();
                ep.put((Object)"org.apache.cxf.fastinfoset.enabled", (Object)Boolean.TRUE);
            }
        }
    }

    protected boolean isHttpVerbSupported(Message message) {
        if (this.isGET(message)) {
            return this.isRequestor(message) && MessageUtils.isTrue((Object)message.getContextualProperty(FI_GET_SUPPORTED));
        }
        return true;
    }
}

