/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerBuilder;
import org.mule.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.module.oauth2.internal.DynamicFlowFactory;
import org.mule.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizationCodeTokenRequestHandler
extends AbstractTokenRequestHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AuthorizationCodeGrantType oauthConfig;
    private HttpListener redirectUrlListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToken(MuleEvent currentEvent, String resourceOwnerId) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing refresh token for user " + resourceOwnerId);
        }
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = this.getOauthConfig().getUserOAuthContext().getContextForResourceOwner(resourceOwnerId);
        boolean lockWasAcquired = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().tryLock();
        try {
            if (lockWasAcquired) {
                this.doRefreshToken(currentEvent, resourceOwnerOAuthContext);
                this.getOauthConfig().getUserOAuthContext().updateResourceOwnerOAuthContext(resourceOwnerOAuthContext);
            }
        }
        finally {
            if (lockWasAcquired) {
                resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
            }
        }
        if (!lockWasAcquired) {
            this.waitUntilLockGetsReleased(resourceOwnerOAuthContext);
        }
    }

    protected abstract void doRefreshToken(MuleEvent var1, ResourceOwnerOAuthContext var2) throws MuleException;

    private void waitUntilLockGetsReleased(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().lock();
        resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
    }

    public void setOauthConfig(AuthorizationCodeGrantType oauthConfig) {
        this.setTlsContextFactory(oauthConfig.getTlsContext());
        this.oauthConfig = oauthConfig;
    }

    public AuthorizationCodeGrantType getOauthConfig() {
        return this.oauthConfig;
    }

    public void init() throws MuleException {
    }

    protected void createListenerForRedirectUrl() throws MuleException {
        try {
            String flowName = "OAuthRedirectUrlFlow" + this.getOauthConfig().getRedirectionUrl();
            Flow redirectUrlFlow = DynamicFlowFactory.createDynamicFlow(this.getMuleContext(), flowName, Arrays.asList(this.createRedirectUrlProcessor()));
            HttpListenerBuilder httpListenerBuilder = new HttpListenerBuilder(this.getMuleContext()).setSuccessStatusCode("#[flowVars['statusCode']]").setUrl(new URL(this.getOauthConfig().getRedirectionUrl())).setFlow(redirectUrlFlow);
            if (this.getOauthConfig().getTlsContext() != null) {
                httpListenerBuilder.setTlsContextFactory(this.getOauthConfig().getTlsContext());
            }
            this.redirectUrlListener = httpListenerBuilder.build();
            this.redirectUrlListener.initialise();
            this.redirectUrlListener.start();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Could not parse provided url %s. Validate that the url is correct", (Object)this.getOauthConfig().getRedirectionUrl());
            throw new DefaultMuleException((Throwable)e);
        }
    }

    protected abstract MessageProcessor createRedirectUrlProcessor();
}

