/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyThread;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SourcePositionFactory;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class ThreadContext {
    private static final int INITIAL_SIZE = 50;
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[50];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[50];
    private int frameIndex = -1;
    private SinglyLinkedList[] crefStack = new SinglyLinkedList[50];
    private int crefIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[50];
    private int scopeIndex = -1;
    private String[] catchStack = new String[50];
    private int catchIndex = -1;
    private ISourcePosition sourcePosition = new SourcePositionFactory(null, 0).getDummyPosition();
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;

    public static synchronized ThreadContext newContext(Ruby runtime) {
        ThreadContext context = new ThreadContext(runtime);
        return context;
    }

    public JumpException prepareJumpException(JumpException.JumpType jumpType, Object target, Object value) {
        JumpException controlException = new JumpException();
        controlException.setJumpType(jumpType);
        controlException.setTarget(target);
        controlException.setValue(value);
        return controlException;
    }

    private ThreadContext(Ruby runtime) {
        this.runtime = runtime;
        this.errorInfo = runtime.getNil();
        this.pushScope(new DynamicScope(new LocalStaticScope(null), null));
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        if (this.frameIndex + 1 == this.frameStack.length) {
            int newSize = this.frameStack.length * 2;
            Frame[] newFrameStack = new Frame[newSize];
            System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
            this.frameStack = newFrameStack;
        }
    }

    private void expandParentsIfNecessary() {
        if (this.parentIndex + 1 == this.parentStack.length) {
            int newSize = this.parentStack.length * 2;
            RubyModule[] newParentStack = new RubyModule[newSize];
            System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
            this.parentStack = newParentStack;
        }
    }

    private void expandCrefsIfNecessary() {
        if (this.crefIndex + 1 == this.crefStack.length) {
            int newSize = this.crefStack.length * 2;
            SinglyLinkedList[] newCrefStack = new SinglyLinkedList[newSize];
            System.arraycopy(this.crefStack, 0, newCrefStack, 0, this.crefStack.length);
            this.crefStack = newCrefStack;
        }
    }

    public void pushScope(DynamicScope scope) {
        this.scopeStack[++this.scopeIndex] = scope;
        this.expandScopesIfNecessary();
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        if (this.scopeIndex + 1 == this.scopeStack.length) {
            int newSize = this.scopeStack.length * 2;
            DynamicScope[] newScopeStack = new DynamicScope[newSize];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
    }

    public IRubyObject getLastline() {
        IRubyObject value = this.getCurrentScope().getLastLine();
        return value == null ? this.runtime.getNil() : value;
    }

    public void setLastline(IRubyObject value) {
        this.getCurrentScope().setLastLine(value);
    }

    private void expandCatchIfNecessary() {
        if (this.catchIndex + 1 == this.catchStack.length) {
            int newSize = this.catchStack.length * 2;
            String[] newCatchStack = new String[newSize];
            System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
            this.catchStack = newCatchStack;
        }
    }

    public void pushCatch(String catchSymbol) {
        this.catchStack[++this.catchIndex] = catchSymbol;
        this.expandCatchIfNecessary();
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public String[] getActiveCatches() {
        if (this.catchIndex < 0) {
            return new String[0];
        }
        String[] activeCatches = new String[this.catchIndex + 1];
        System.arraycopy(this.catchStack, 0, activeCatches, 0, this.catchIndex + 1);
        return activeCatches;
    }

    private void pushFrameCopy() {
        this.pushFrame(this.getCurrentFrame().duplicate());
    }

    private void pushCallFrame(RubyModule clazz, String name, IRubyObject self, IRubyObject[] args, int req, Block block, Object jumpTarget) {
        this.pushFrame(new Frame(clazz, self, name, args, req, block, this.getPosition(), jumpTarget));
    }

    private void pushFrame() {
        this.pushFrame(new Frame(this.getPosition()));
    }

    private void pushFrame(Frame frame) {
        this.frameStack[++this.frameIndex] = frame;
        this.expandFramesIfNecessary();
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex];
        this.frameStack[this.frameIndex--] = null;
        this.setPosition(frame.getPosition());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public Frame getPreviousFrame() {
        int size = this.frameIndex + 1;
        return size <= 1 ? null : this.frameStack[size - 2];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject[] getFrameArgs() {
        return this.getCurrentFrame().getArgs();
    }

    public void setFrameArgs(IRubyObject[] args) {
        this.getCurrentFrame().setArgs(args);
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public Object getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public void setFrameJumpTarget(Object target) {
        this.getCurrentFrame().setJumpTarget(target);
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public ISourcePosition getFramePosition() {
        return this.getCurrentFrame().getPosition();
    }

    public ISourcePosition getPreviousFramePosition() {
        return this.getPreviousFrame().getPosition();
    }

    public ISourcePosition getPosition() {
        return this.sourcePosition;
    }

    public String getSourceFile() {
        return this.sourcePosition.getFile();
    }

    public int getSourceLine() {
        return this.sourcePosition.getEndLine();
    }

    public void setPosition(ISourcePosition position) {
        this.sourcePosition = position;
    }

    public IRubyObject getBackref() {
        IRubyObject value = this.getCurrentScope().getBackRef();
        return value == null ? this.runtime.getNil() : value;
    }

    public void setBackref(IRubyObject backref) {
        if (!(backref instanceof RubyMatchData) && !backref.isNil()) {
            throw this.runtime.newTypeError(backref, this.runtime.getClass("MatchData"));
        }
        this.getCurrentScope().setBackRef(backref);
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents();
    }

    public SinglyLinkedList peekCRef() {
        return this.crefStack[this.crefIndex];
    }

    public void setCRef(SinglyLinkedList newCRef) {
        this.crefStack[++this.crefIndex] = newCRef;
        this.expandCrefsIfNecessary();
    }

    public void unsetCRef() {
        this.crefStack[this.crefIndex--] = null;
    }

    public SinglyLinkedList pushCRef(RubyModule newModule) {
        if (this.crefIndex == -1) {
            this.crefStack[++this.crefIndex] = new SinglyLinkedList(newModule, null);
        } else {
            this.crefStack[this.crefIndex] = new SinglyLinkedList(newModule, this.crefStack[this.crefIndex]);
        }
        return this.peekCRef();
    }

    public RubyModule popCRef() {
        SinglyLinkedList next;
        assert (this.crefIndex != -1) : "Tried to pop from empty CRef stack";
        RubyModule module = (RubyModule)this.peekCRef().getValue();
        if ((next = this.crefStack[this.crefIndex--].getNext()) != null) {
            this.crefStack[++this.crefIndex] = next;
        } else {
            this.crefStack[this.crefIndex + 1] = null;
        }
        return module;
    }

    public void pushRubyClass(RubyModule currentModule) {
        assert (currentModule != null) : "Can't push null RubyClass";
        this.parentStack[++this.parentIndex] = currentModule;
        this.expandParentsIfNecessary();
    }

    public RubyModule popRubyClass() {
        RubyModule ret = this.parentStack[this.parentIndex];
        this.parentStack[this.parentIndex--] = null;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        RubyModule parentModule = null;
        parentModule = this.parentIndex == 0 ? this.parentStack[this.parentIndex] : this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean isTopLevel() {
        return this.parentIndex == 0;
    }

    public boolean getConstantDefined(String name) {
        IRubyObject result = null;
        IRubyObject undef = this.runtime.getUndef();
        for (SinglyLinkedList cbase = this.peekCRef(); cbase != null; cbase = cbase.getNext()) {
            RubyModule module = (RubyModule)cbase.getValue();
            result = module.getInstanceVariable(name);
            if (result == undef) {
                module.removeInstanceVariable(name);
                return this.runtime.getLoadService().autoload(module.getName() + "::" + name) != null;
            }
            if (result == null) continue;
            return true;
        }
        return false;
    }

    public IRubyObject getConstant(String name) {
        SinglyLinkedList cbase = this.peekCRef();
        RubyClass object = this.runtime.getObject();
        IRubyObject result = null;
        IRubyObject undef = this.runtime.getUndef();
        do {
            RubyModule klass;
            if ((result = (klass = (RubyModule)cbase.getValue()).getInstanceVariable(name)) == undef) {
                klass.removeInstanceVariable(name);
                if (this.runtime.getLoadService().autoload(klass.getName() + "::" + name) != null) continue;
                break;
            }
            if (result != null) {
                return result;
            }
            cbase = cbase.getNext();
        } while (cbase != null && cbase.getValue() != object);
        return ((RubyModule)this.peekCRef().getValue()).getConstant(name);
    }

    public IRubyObject setConstantInCurrent(String name, IRubyObject result) {
        if (this.getRubyClass() == null) {
            throw this.runtime.newTypeError("no class/module to define constant");
        }
        RubyModule module = (RubyModule)this.peekCRef().getValue();
        this.setConstantInModule(name, module, result);
        return result;
    }

    public IRubyObject setConstantInModule(String name, RubyModule module, IRubyObject result) {
        module.setConstant(name, result);
        return result;
    }

    public IRubyObject setConstantInObject(String name, IRubyObject result) {
        this.setConstantInModule(name, this.runtime.getObject(), result);
        return result;
    }

    public IRubyObject getConstant(String name, RubyModule module) {
        SinglyLinkedList cbase = module.getCRef();
        IRubyObject result = null;
        IRubyObject undef = this.runtime.getUndef();
        do {
            RubyModule klass;
            if ((result = (klass = (RubyModule)cbase.getValue()).getInstanceVariable(name)) == undef) {
                klass.removeInstanceVariable(name);
                if (this.runtime.getLoadService().autoload(klass.getName() + "::" + name) != null) continue;
                break;
            }
            if (result != null) {
                return result;
            }
            cbase = cbase.getNext();
        } while (cbase != null);
        return ((RubyModule)this.peekCRef().getValue()).getConstant(name);
    }

    private static void addBackTraceElement(RubyArray backtrace, Frame frame, Frame previousFrame) {
        StringBuffer sb = new StringBuffer(100);
        ISourcePosition position = frame.getPosition();
        if (previousFrame != null && frame.getName() != null && previousFrame.getName() != null && frame.getName().equals(previousFrame.getName()) && frame.getPosition().getFile().equals(previousFrame.getPosition().getFile()) && frame.getPosition().getEndLine() == previousFrame.getPosition().getEndLine()) {
            return;
        }
        sb.append(position.getFile()).append(':').append(position.getEndLine());
        if (previousFrame != null && previousFrame.getName() != null) {
            sb.append(":in `").append(previousFrame.getName()).append('\'');
        } else if (previousFrame == null && frame.getName() != null) {
            sb.append(":in `").append(frame.getName()).append('\'');
        }
        backtrace.append(backtrace.getRuntime().newString(sb.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, Frame[] backtraceFrames) {
        Frame frame;
        RubyArray backtrace = runtime.newArray();
        int traceSize = backtraceFrames.length;
        if (traceSize <= 0) {
            return backtrace;
        }
        for (int i = traceSize - 1; !(i <= 0 || (frame = backtraceFrames[i]) != null && frame.isBindingFrame()); --i) {
            ThreadContext.addBackTraceElement(backtrace, frame, backtraceFrames[i - 1]);
        }
        return backtrace;
    }

    public Frame[] createBacktrace(int level, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.pushCRef(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type) {
        this.pushCRef(type);
        this.pushRubyClass(type);
    }

    public void postCompiledClass() {
        this.popCRef();
        this.popRubyClass();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type) {
        this.pushCRef(type);
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(new DynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postClassEval() {
        this.popCRef();
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodCall(RubyModule implementationClass, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, int req, Block block, boolean noSuper, Object jumpTarget) {
        this.pushRubyClass((RubyModule)implementationClass.getCRef().getValue());
        this.pushCallFrame(noSuper ? null : clazz, name, self, args, req, block, jumpTarget);
    }

    public void postMethodCall() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preDefMethodInternalCall(RubyModule clazz, String name, IRubyObject self, IRubyObject[] args, int req, Block block, boolean noSuper, SinglyLinkedList cref, StaticScope staticScope, Object jumpTarget) {
        RubyModule implementationClass = (RubyModule)cref.getValue();
        this.setCRef(cref);
        this.pushCallFrame(noSuper ? null : clazz, name, self, args, req, block, jumpTarget);
        this.pushScope(new DynamicScope(staticScope, this.getCurrentScope()));
        this.pushRubyClass(implementationClass);
    }

    public void postDefMethodInternalCall() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
        this.unsetCRef();
    }

    public void preCompiledMethod(RubyModule implementationClass, SinglyLinkedList cref) {
        this.pushRubyClass(implementationClass);
        this.setCRef(cref);
    }

    public void postCompiledMethod() {
        this.popRubyClass();
        this.unsetCRef();
    }

    public void preReflectedMethodInternalCall(RubyModule implementationClass, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, int req, boolean noSuper, Block block, Object jumpTarget) {
        this.pushRubyClass((RubyModule)implementationClass.getCRef().getValue());
        this.pushCallFrame(noSuper ? null : klazz, name, self, args, req, block, jumpTarget);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postReflectedMethodInternalCall() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preInitCoreClasses() {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void preInitBuiltinClasses(RubyClass objectClass, IRubyObject topSelf) {
        this.pushRubyClass(objectClass);
        this.setCRef(objectClass.getCRef());
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushCallFrame(null, null, self, IRubyObject.NULL_ARRAY, 0, Block.NULL_BLOCK, null);
        this.setCRef(rubyClass.getCRef());
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
        this.unsetCRef();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        this.pushCRef(executeUnderClass);
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), frame.getArgs(), frame.getRequiredArgCount(), block, frame.getJumpTarget());
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popRubyClass();
        this.popCRef();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame currentFrame) {
        this.pushFrame(currentFrame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public void preForBlock(Block block, RubyModule klass) {
        this.pushFrame(block.getFrame());
        this.setCRef(block.getCRef());
        this.getCurrentFrame().setVisibility(block.getVisibility());
        this.pushScope(block.getDynamicScope());
        this.pushRubyClass(klass != null ? klass : block.getKlass());
    }

    public void preYieldSpecificBlock(Block block, RubyModule klass) {
        this.pushFrame(block.getFrame());
        this.setCRef(block.getCRef());
        this.getCurrentFrame().setVisibility(block.getVisibility());
        this.pushScope(block.getDynamicScope().cloneScope());
        this.pushRubyClass(klass != null ? klass : block.getKlass());
    }

    public void preEvalWithBinding(Block block) {
        Frame frame = block.getFrame();
        frame.setIsBindingFrame(true);
        this.pushFrame(block.getFrame());
        this.setCRef(block.getCRef());
        this.getCurrentFrame().setVisibility(block.getVisibility());
        this.pushRubyClass(block.getKlass());
    }

    public void postEvalWithBinding(Block block) {
        block.getFrame().setIsBindingFrame(false);
        this.popFrame();
        this.unsetCRef();
        this.popRubyClass();
    }

    public void postYield() {
        this.popScope();
        this.popFrame();
        this.unsetCRef();
        this.popRubyClass();
    }

    public void preRootNode(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postRootNode() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }
}

