/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import org.jruby.Ruby;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public abstract class FastInvocationCallback
implements Callback {
    private Arity arity;

    public IRubyObject execute(IRubyObject recv, IRubyObject[] oargs, Block block) {
        Ruby runtime = recv.getRuntime();
        this.arity.checkArity(runtime, oargs);
        try {
            return this.call(recv, oargs);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2);

    public void setArity(Arity arity) {
        this.arity = arity;
    }

    public Arity getArity() {
        return this.arity;
    }
}

