/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.routing.AbstractUntilSuccessfulProcessingStrategy;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.queue.objectstore.QueueKey;

public class AsynchronousUntilSuccessfulProcessingStrategy
extends AbstractUntilSuccessfulProcessingStrategy
implements Initialisable,
Startable,
Stoppable,
MessagingExceptionHandlerAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private MessagingExceptionHandler messagingExceptionHandler;
    private ScheduledExecutorService scheduledPool;

    @Override
    public void initialise() throws InitialisationException {
        if (this.getUntilSuccessfulConfiguration().getObjectStore() == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("A ListableObjectStore must be configured on UntilSuccessful."), (Initialisable)this);
        }
    }

    @Override
    public void start() {
        String threadPrefix = String.format("%s%s.%s", ThreadNameHelper.getPrefix(this.getUntilSuccessfulConfiguration().getMuleContext()), this.getUntilSuccessfulConfiguration().getFlowConstruct().getName(), "until-successful");
        this.scheduledPool = this.getUntilSuccessfulConfiguration().getThreadingProfile().createScheduledPool(threadPrefix);
        this.scheduleAllPendingEventsForProcessing();
    }

    @Override
    public void stop() {
        this.scheduledPool.shutdown();
        this.scheduledPool = null;
    }

    @Override
    public MuleEvent route(MuleEvent event) throws MessagingException {
        try {
            this.ensurePayloadSerializable(event);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to prepare message for processing"), event, e, this.getUntilSuccessfulConfiguration().getRouter());
        }
        try {
            Serializable eventStoreKey = this.storeEvent(event);
            this.scheduleForProcessing(eventStoreKey, true);
            if (this.getUntilSuccessfulConfiguration().getAckExpression() == null) {
                return VoidMuleEvent.getInstance();
            }
            return this.processResponseThroughAckResponseExpression(event);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to schedule the event for processing"), event, e, this.getUntilSuccessfulConfiguration().getRouter());
        }
    }

    private void scheduleAllPendingEventsForProcessing() {
        block5: {
            try {
                for (Serializable eventStoreKey : this.getUntilSuccessfulConfiguration().getObjectStore().allKeys()) {
                    try {
                        this.scheduleForProcessing(eventStoreKey, true);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)MessageFactory.createStaticMessage("Failed to schedule for processing event stored with key: " + eventStoreKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failure during scheduling of until successful previous jobs " + e.getMessage()));
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug((Object)e);
            }
        }
    }

    private void scheduleForProcessing(final Serializable eventStoreKey, boolean firstTime) throws Exception {
        this.scheduledPool.schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.retrieveAndProcessEvent(eventStoreKey);
                }
                catch (Exception e) {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.incrementProcessAttemptCountAndRescheduleOrRemoveFromStore(eventStoreKey);
                }
                return null;
            }
        }, firstTime ? 0L : this.getUntilSuccessfulConfiguration().getMillisBetweenRetries(), TimeUnit.MILLISECONDS);
    }

    private void incrementProcessAttemptCountAndRescheduleOrRemoveFromStore(Serializable eventStoreKey) throws Exception {
        try {
            MuleEvent event = (MuleEvent)this.getUntilSuccessfulConfiguration().getObjectStore().remove(eventStoreKey);
            MuleEvent mutableEvent = this.threadSafeCopy(event);
            MuleMessage message = mutableEvent.getMessage();
            Integer deliveryAttemptCount = message.getInvocationProperty("process.attempt.count", 1);
            if (deliveryAttemptCount <= this.getUntilSuccessfulConfiguration().getMaxRetries()) {
                message.setInvocationProperty("process.attempt.count", deliveryAttemptCount + 1);
                this.getUntilSuccessfulConfiguration().getObjectStore().store(eventStoreKey, mutableEvent);
                this.scheduleForProcessing(eventStoreKey, false);
            } else {
                this.abandonRetries(event, mutableEvent);
            }
        }
        catch (ObjectStoreException ose) {
            this.logger.error((Object)("Failed to increment failure count for event stored with key: " + eventStoreKey), (Throwable)ose);
        }
    }

    private Serializable storeEvent(MuleEvent event) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        Integer deliveryAttemptCount = message.getInvocationProperty("process.attempt.count", 1);
        return this.storeEvent(event, deliveryAttemptCount);
    }

    private Serializable storeEvent(MuleEvent event, int deliveryAttemptCount) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        message.setInvocationProperty("process.attempt.count", deliveryAttemptCount);
        Serializable eventStoreKey = AsynchronousUntilSuccessfulProcessingStrategy.buildQueueKey(event);
        this.getUntilSuccessfulConfiguration().getObjectStore().store(eventStoreKey, event);
        return eventStoreKey;
    }

    public static Serializable buildQueueKey(MuleEvent muleEvent) {
        String key = muleEvent.getFlowConstruct() + "-" + muleEvent.getMuleContext().getClusterId() + "-" + muleEvent.getId();
        return new QueueKey("queuestore", (Serializable)((Object)key));
    }

    private void abandonRetries(MuleEvent event, MuleEvent mutableEvent) {
        if (this.getUntilSuccessfulConfiguration().getDlqMP() == null) {
            this.logger.info((Object)"Retry attempts exhausted and no DLQ defined");
            RetryPolicyExhaustedException retryPolicyExhaustedException = new RetryPolicyExhaustedException(CoreMessages.createStaticMessage("until-successful retries exhausted"), (Object)this);
            this.messagingExceptionHandler.handleException(new MessagingException(event, (Throwable)retryPolicyExhaustedException), event);
            return;
        }
        this.logger.info((Object)("Retry attempts exhausted, routing message to DLQ: " + this.getUntilSuccessfulConfiguration().getDlqMP()));
        try {
            this.getUntilSuccessfulConfiguration().getDlqMP().process(mutableEvent);
        }
        catch (MessagingException e) {
            this.messagingExceptionHandler.handleException(e, event);
        }
        catch (Exception e) {
            this.messagingExceptionHandler.handleException(new MessagingException(event, (Throwable)e), event);
        }
    }

    private void removeFromStore(Serializable eventStoreKey) {
        try {
            this.getUntilSuccessfulConfiguration().getObjectStore().remove(eventStoreKey);
        }
        catch (ObjectStoreException ose) {
            this.logger.warn((Object)("Failed to remove following event from store with key: " + eventStoreKey));
        }
    }

    private void retrieveAndProcessEvent(Serializable eventStoreKey) throws ObjectStoreException {
        MuleEvent persistedEvent = (MuleEvent)this.getUntilSuccessfulConfiguration().getObjectStore().retrieve(eventStoreKey);
        MuleEvent mutableEvent = this.threadSafeCopy(persistedEvent);
        this.processEvent(mutableEvent);
        this.removeFromStore(eventStoreKey);
    }

    protected MuleEvent threadSafeCopy(MuleEvent event) {
        DefaultMuleMessage message = new DefaultMuleMessage(event.getMessage().getPayload(), event.getMessage(), this.getUntilSuccessfulConfiguration().getMuleContext());
        return new DefaultMuleEvent(message, event);
    }

    private void ensurePayloadSerializable(MuleEvent event) throws Exception {
        MuleMessage message = event.getMessage();
        if (message instanceof DefaultMuleMessage) {
            if (((DefaultMuleMessage)message).isConsumable()) {
                message.getPayloadAsBytes();
            } else if (!(message.getPayload() instanceof Serializable)) {
                throw new NotSerializableException(message.getPayload().getClass().getCanonicalName());
            }
        } else {
            message.getPayloadAsBytes();
        }
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }
}

