/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.schedule;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.schedule.Scheduler;
import org.mule.lifecycle.DefaultLifecycleManager;
import org.mule.lifecycle.SimpleLifecycleManager;
import org.mule.transport.polling.schedule.PollScheduler;

public class FixedFrequencyScheduler<T extends Runnable>
extends PollScheduler<T> {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private ExecutorService executor;
    private TimeUnit timeUnit;
    private long frequency;
    private long startDelay;
    private final SimpleLifecycleManager<Scheduler> lifecycleManager;

    public FixedFrequencyScheduler(String name, long frequency, long startDelay, T job, TimeUnit timeUnit) {
        super(name, job);
        this.frequency = frequency;
        this.startDelay = startDelay;
        this.job = job;
        this.timeUnit = timeUnit;
        this.lifecycleManager = new DefaultLifecycleManager<FixedFrequencyScheduler>(name, this);
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<Scheduler>(){

                @Override
                public void onTransition(String phaseName, Scheduler object) throws MuleException {
                    FixedFrequencyScheduler.this.executor = Executors.newSingleThreadScheduledExecutor();
                }
            });
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.isNotStarted()) {
            this.lifecycleManager.fireStartPhase(new LifecycleCallback<Scheduler>(){

                @Override
                public void onTransition(String phaseName, Scheduler object) throws MuleException {
                    FixedFrequencyScheduler.this.executor.shutdown();
                    FixedFrequencyScheduler.this.executor = Executors.newSingleThreadScheduledExecutor();
                    ((ScheduledExecutorService)FixedFrequencyScheduler.this.executor).scheduleAtFixedRate(FixedFrequencyScheduler.this.job, FixedFrequencyScheduler.this.startDelay, FixedFrequencyScheduler.this.frequency, FixedFrequencyScheduler.this.timeUnit);
                }
            });
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (this.isNotStopped()) {
            this.lifecycleManager.fireStopPhase(new LifecycleCallback<Scheduler>(){

                @Override
                public void onTransition(String phaseName, Scheduler object) throws MuleException {
                    FixedFrequencyScheduler.this.executor.shutdown();
                    FixedFrequencyScheduler.this.executor = Executors.newSingleThreadExecutor();
                }
            });
        }
    }

    @Override
    public void schedule() throws MuleException {
        this.executor.submit(this.job);
    }

    @Override
    public void dispose() {
        try {
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<Scheduler>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTransition(String phaseName, Scheduler object) throws MuleException {
                    try {
                        FixedFrequencyScheduler.this.executor.shutdown();
                        FixedFrequencyScheduler.this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        FixedFrequencyScheduler.this.executor.shutdownNow();
                    }
                    finally {
                        if (!FixedFrequencyScheduler.this.executor.isTerminated()) {
                            FixedFrequencyScheduler.this.executor.shutdownNow();
                        }
                    }
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("The Scheduler " + this.name + " could not be disposed"));
        }
    }

    private boolean isNotStopped() {
        return !this.lifecycleManager.getState().isStopped() && !this.lifecycleManager.getState().isStopping();
    }

    private boolean isNotStarted() {
        return !this.lifecycleManager.getState().isStarted() && !this.lifecycleManager.getState().isStarting();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

