/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.journal.JournalEntry;
import org.mule.util.journal.JournalEntrySerializer;
import org.mule.util.journal.TransactionCompletePredicate;
import org.mule.util.journal.TransactionJournal;
import org.mule.util.journal.queue.AbstractQueueTxJournalEntry;
import org.mule.util.queue.QueueStore;

public abstract class AbstractQueueTransactionJournal<T, K extends JournalEntry<T>> {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private TransactionJournal<T, K> logFile;

    public AbstractQueueTransactionJournal(String logFilesDirectory, JournalEntrySerializer journalEntrySerializer) {
        this.logFile = new TransactionJournal(logFilesDirectory, new TransactionCompletePredicate(){

            @Override
            public boolean isTransactionComplete(JournalEntry journalEntry) {
                AbstractQueueTxJournalEntry abstractQueueTxJournalEntry = (AbstractQueueTxJournalEntry)journalEntry;
                return abstractQueueTxJournalEntry.isCommit() || abstractQueueTxJournalEntry.isRollback();
            }
        }, journalEntrySerializer);
    }

    public void logAdd(T txId, QueueStore queue, Serializable value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logging queue add operation for tx " + txId));
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ADD.getByteRepresentation(), queue.getName(), value));
    }

    public void logAddFirst(T txId, QueueStore queue, Serializable item) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logging queue add first operation for tx " + txId));
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ADD_FIRST.getByteRepresentation(), queue.getName(), item));
    }

    public void logRemove(T txId, QueueStore queue, Serializable value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logging queue remove operation for tx " + txId));
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.REMOVE.getByteRepresentation(), queue.getName(), value));
    }

    public void logCommit(T txId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logging queue commit operation for tx " + txId));
        }
        this.logFile.logCheckpointOperation((JournalEntry<T>)this.createCheckpointJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.COMMIT.getByteRepresentation()));
    }

    protected abstract K createUpdateJournalEntry(T var1, byte var2, String var3, Serializable var4);

    protected abstract K createCheckpointJournalEntry(T var1, byte var2);

    public void logRollback(T txId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logging queue rollback operation for tx " + txId));
        }
        this.logFile.logCheckpointOperation((JournalEntry<T>)this.createCheckpointJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ROLLBACK.getByteRepresentation()));
    }

    public synchronized void close() {
        this.logFile.close();
    }

    public synchronized void clear() {
        this.logFile.clear();
    }

    public Multimap<T, K> getAllLogEntries() {
        return this.logFile.getAllLogEntries();
    }

    public Collection<K> getLogEntriesForTx(T txId) {
        return this.logFile.getLogEntriesForTx(txId);
    }

    protected TransactionJournal<T, K> getJournal() {
        return this.logFile;
    }
}

