/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.ManageNameIDRequest;
import org.opensaml.saml2.core.validator.RequestAbstractTypeSchemaValidator;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageNameIDRequestSchemaValidator
extends RequestAbstractTypeSchemaValidator<ManageNameIDRequest> {
    @Override
    public void validate(ManageNameIDRequest request) throws ValidationException {
        super.validate(request);
        this.validateNameID(request);
        this.validateNewIDAndTerminate(request);
    }

    protected void validateNameID(ManageNameIDRequest request) throws ValidationException {
        int idCount = 0;
        if (request.getNameID() != null) {
            ++idCount;
        }
        if (request.getEncryptedID() != null) {
            ++idCount;
        }
        if (idCount != 1) {
            throw new ValidationException("ManageNameIDRequest must contain exactly one of: NameID, EncryptedID");
        }
    }

    protected void validateNewIDAndTerminate(ManageNameIDRequest request) throws ValidationException {
        int count = 0;
        if (request.getNewID() != null) {
            ++count;
        }
        if (request.getNewEncryptedID() != null) {
            ++count;
        }
        if (request.getTerminate() != null) {
            ++count;
        }
        if (count != 1) {
            throw new ValidationException("ManageNameIDRequest must contain exactly one of: NewID, NewEncryptedID, Terminate");
        }
    }
}

