/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultMuleMessageNullTransformationTestCase
extends AbstractMuleTestCase {
    @Test
    public void transformerIsNeverCalledWithANullValue() throws MuleException {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isCacheMessageOriginalPayload()).thenReturn((Object)false);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Transformer transformer1 = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer1.transform(Matchers.any(Object.class))).thenReturn(null);
        Mockito.when((Object)transformer1.isSourceDataTypeSupported((DataType)Matchers.any(DataType.class))).thenReturn((Object)true);
        Transformer transformer2 = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer2.transform(Matchers.any(Object.class))).thenReturn((Object)"foo");
        Mockito.when((Object)transformer2.isSourceDataTypeSupported((DataType)Matchers.any(DataType.class))).thenReturn((Object)true);
        DefaultMuleMessage message = new DefaultMuleMessage(null, muleContext);
        message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
        Assert.assertEquals((Object)"foo", (Object)message.getPayload());
        ((Transformer)Mockito.verify((Object)transformer1, (VerificationMode)Mockito.never())).transform(null);
        ((Transformer)Mockito.verify((Object)transformer1, (VerificationMode)Mockito.never())).isAcceptNull();
        ((Transformer)Mockito.verify((Object)transformer2, (VerificationMode)Mockito.never())).transform(null);
        ((Transformer)Mockito.verify((Object)transformer2, (VerificationMode)Mockito.never())).isAcceptNull();
    }
}

