/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SerializationException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.SerializationUtils;

public class InvocationPropertiesTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void setInvocationPropertyBeforeNewEvent() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        message.setProperty("key", (Object)"value", PropertyScope.INVOCATION);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Assert.assertEquals((Object)"value", (Object)message.getProperty("key", PropertyScope.INVOCATION));
        Assert.assertEquals((Object)"value", (Object)event.getFlowVariable("key"));
    }

    @Test
    public void setInvocationPropertyBeforeExistingEvent() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        message.setProperty("key", (Object)"value", PropertyScope.INVOCATION);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        event.setFlowVariable("key", (Object)"VALUE");
        event.setFlowVariable("key2", (Object)"value2");
        Assert.assertEquals((Object)"VALUE", (Object)message.getProperty("key", PropertyScope.INVOCATION));
        Assert.assertEquals((Object)"value2", (Object)message.getProperty("key2", PropertyScope.INVOCATION));
        Assert.assertEquals((Object)"VALUE", (Object)event.getFlowVariable("key"));
        Assert.assertEquals((Object)"value2", (Object)event.getFlowVariable("key2"));
    }

    @Test
    public void setInvocationPropertyViaMessageAPI() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("key", (Object)"value", PropertyScope.INVOCATION);
        message.setProperty("key2", nonSerializable, PropertyScope.INVOCATION);
        Assert.assertEquals((long)2L, (long)event.getFlowVariableNames().size());
        Assert.assertEquals((Object)"value", (Object)event.getFlowVariable("key"));
        Assert.assertEquals((Object)nonSerializable, (Object)event.getFlowVariable("key2"));
    }

    @Test
    public void getInvocationPropertyViaMessageAPI() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        event.setFlowVariable("key", (Object)"value");
        event.setFlowVariable("key2", nonSerializable);
        Assert.assertEquals((long)2L, (long)message.getPropertyNames(PropertyScope.INVOCATION).size());
        Assert.assertEquals((Object)"value", (Object)message.getInvocationProperty("key"));
        Assert.assertEquals((Object)nonSerializable, (Object)message.getInvocationProperty("key2"));
    }

    @Test
    public void asyncInterceptingProcessorInvocationPropertyPropagation() throws Exception {
        AsyncInterceptingMessageProcessor async = new AsyncInterceptingMessageProcessor(muleContext.getDefaultThreadingProfile(), "async", 0);
        SensingNullMessageProcessor asyncListener = new SensingNullMessageProcessor();
        async.setListener((MessageProcessor)asyncListener);
        async.start();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        message.setInvocationProperty("key", (Object)"value");
        async.process((MuleEvent)event);
        asyncListener.latch.await(5000L, TimeUnit.MILLISECONDS);
        MuleEvent asyncEvent = asyncListener.event;
        Assert.assertNotSame((Object)asyncEvent, (Object)event);
        Assert.assertNotSame((Object)asyncEvent.getSession(), (Object)event.getSession());
        Assert.assertEquals((Object)"value", (Object)message.getInvocationProperty("key"));
        message.setProperty("newKey", (Object)"newValue", PropertyScope.INVOCATION);
        Assert.assertEquals((Object)"newValue", (Object)message.getInvocationProperty("newKey"));
        Assert.assertNull((Object)event.getSession().getProperty("newKey"));
        async.stop();
    }

    @Test
    public void serializationInvocationPropertyPropagation() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        message.setInvocationProperty("key", (Object)"value");
        MuleEvent deserializedEvent = (MuleEvent)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)event), (MuleContext)muleContext);
        Assert.assertNotSame((Object)deserializedEvent, (Object)event);
        Assert.assertNotSame((Object)deserializedEvent, (Object)event);
        Assert.assertNotSame((Object)deserializedEvent.getSession(), (Object)event.getSession());
        Assert.assertNotSame((Object)deserializedEvent.getSession(), (Object)event.getSession());
        Assert.assertEquals((Object)"value", (Object)deserializedEvent.getMessage().getInvocationProperty("key"));
        deserializedEvent.getMessage().setInvocationProperty("newKey", (Object)"newValue");
        Assert.assertEquals((Object)"newValue", (Object)deserializedEvent.getMessage().getInvocationProperty("newKey"));
        Assert.assertNull((Object)event.getMessage().getInvocationProperty("newKey"));
    }

    @Test
    public void serializationNonSerializableInvocationPropertyPropagation() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setInvocationProperty("key", nonSerializable);
        message.setInvocationProperty("key2", (Object)"value2");
        try {
            SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)event), (MuleContext)muleContext);
            Assert.fail((String)"Serialization should have failed.");
        }
        catch (Exception e) {
            Assert.assertEquals(SerializationException.class, e.getClass());
        }
    }

    @Test
    public void processFlowInvocationPropertyPropagation() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        SensingNullMessageProcessor flowListener = new SensingNullMessageProcessor();
        Flow flow = new Flow("flow", muleContext);
        flow.setMessageProcessors(Collections.singletonList(flowListener));
        flow.initialise();
        flow.start();
        Object nonSerializable = new Object();
        message.setInvocationProperty("key", (Object)"value");
        message.setInvocationProperty("key2", nonSerializable);
        flow.process((MuleEvent)event);
        flowListener.latch.await(5000L, TimeUnit.MILLISECONDS);
        MuleEvent processedEvent = flowListener.event;
        Assert.assertNotSame((Object)processedEvent, (Object)event);
        Assert.assertEquals((Object)processedEvent, (Object)event);
        Assert.assertSame((Object)processedEvent.getSession(), (Object)event.getSession());
        Assert.assertEquals((Object)"value", (Object)processedEvent.getMessage().getInvocationProperty("key"));
        Assert.assertEquals((Object)nonSerializable, (Object)processedEvent.getMessage().getInvocationProperty("key2"));
        processedEvent.getMessage().setInvocationProperty("newKey", (Object)"newValue");
        Assert.assertEquals((Object)"newValue", (Object)processedEvent.getMessage().getInvocationProperty("newKey"));
        Assert.assertEquals((Object)"newValue", (Object)event.getMessage().getInvocationProperty("newKey"));
        flow.stop();
        flow.dispose();
    }
}

