/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.AbstractAddVariablePropertyTransformer;
import org.mule.transformer.simple.AddFlowVariableTransformer;
import org.mule.transformer.simple.AddPropertyTransformer;
import org.mule.transformer.simple.AddSessionVariableTransformer;

@RunWith(value=Parameterized.class)
@SmallTest
public class AddVariablePropertyTransformerTestCase
extends AbstractMuleTestCase {
    public static final String ENCODING = "encoding";
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#[string:someValue]";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[string:someValueNull]";
    public static final String NULL_EXPRESSION_VALUE = null;
    private MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExpressionManager mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private AbstractAddVariablePropertyTransformer addVariableTransformer;
    private PropertyScope scope;

    public AddVariablePropertyTransformerTestCase(AbstractAddVariablePropertyTransformer abstractAddVariableTransformer, PropertyScope scope) {
        this.addVariableTransformer = abstractAddVariableTransformer;
        this.scope = scope;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new AddFlowVariableTransformer(), PropertyScope.INVOCATION}, {new AddSessionVariableTransformer(), PropertyScope.SESSION}, {new AddPropertyTransformer(), PropertyScope.OUTBOUND});
    }

    @Before
    public void setUpTest() {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.mockMessage)).thenReturn((Object)EXPRESSION_VALUE);
        this.addVariableTransformer.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void testAddVariable() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty(PLAIN_STRING_KEY, (Object)PLAIN_STRING_VALUE, this.scope);
    }

    @Test
    public void testAddVariableWithExpressionValue() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(EXPRESSION);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty(PLAIN_STRING_KEY, (Object)EXPRESSION_VALUE, this.scope);
    }

    @Test
    public void testAddVariableWithExpressionKey() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(EXPRESSION);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty(EXPRESSION_VALUE, (Object)PLAIN_STRING_VALUE, this.scope);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullKey() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullValue() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setValue(null);
    }

    @Test
    public void testAddVariableWithNullExpressionKeyResult() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(NULL_EXPRESSION);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)0))).setProperty(Matchers.anyString(), (Object)Matchers.anyString(), (PropertyScope)Matchers.anyObject());
    }

    @Test
    public void testAddVariableWithNullExpressionValueResult() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(NULL_EXPRESSION);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)0))).setProperty(Matchers.anyString(), (Object)Matchers.anyString(), (PropertyScope)Matchers.anyObject());
    }
}

