/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.transport.MessageDispatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectorLifecycleManager;
import org.mule.transport.MessageDispatcherUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MessageDispatcherUtilsTestCase
extends AbstractMuleTestCase {
    @Mock
    private AbstractConnector connector;
    @Mock
    private ConnectorLifecycleManager connectorLifecycleManager;
    @Mock
    private MessageDispatcher dispatcher;
    @Mock
    private LifecycleState dispatcherLifecycleState;

    @Before
    public void setUp() {
        Mockito.when((Object)this.dispatcher.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)this.dispatcher.getLifecycleState()).thenReturn((Object)this.dispatcherLifecycleState);
        Mockito.when((Object)this.connector.getLifecycleManager()).thenReturn((Object)this.connectorLifecycleManager);
    }

    @Test
    public void startsAndInitialisesDispatcherWhenStartingConnector() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"start");
        Mockito.when((Object)this.dispatcherLifecycleState.isStarted()).thenReturn((Object)false);
        Mockito.when((Object)this.dispatcherLifecycleState.isInitialised()).thenReturn((Object)false);
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher)).initialise();
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher)).start();
    }

    @Test
    public void startsInitialisedDispatcherWhenStartingConnector() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"start");
        Mockito.when((Object)this.dispatcherLifecycleState.isStarted()).thenReturn((Object)false);
        Mockito.when((Object)this.dispatcherLifecycleState.isInitialised()).thenReturn((Object)true);
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher)).start();
    }

    @Test
    public void doesntStartAlreadyStartedDispatcher() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"start");
        Mockito.when((Object)this.dispatcherLifecycleState.isStarted()).thenReturn((Object)true);
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void stopsDispatcherWhenStoppingConnector() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"stop");
        Mockito.when((Object)this.dispatcherLifecycleState.isStarted()).thenReturn((Object)true);
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher)).stop();
    }

    @Test
    public void doesntStopAlreadyStoppedDispatcher() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"stop");
        Mockito.when((Object)this.dispatcherLifecycleState.isStarted()).thenReturn((Object)false);
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void disposesDispatcherWhenDisposingConnector() throws MuleException {
        Mockito.when((Object)this.connectorLifecycleManager.getCurrentPhase()).thenReturn((Object)"dispose");
        MessageDispatcherUtils.applyLifecycle((MessageDispatcher)this.dispatcher);
        ((MessageDispatcher)Mockito.verify((Object)this.dispatcher)).dispose();
    }
}

