/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.AttributeEvaluator;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AttributeEvaluatorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExpressionManager mockExpressionManager;
    @Mock
    private MuleEvent mockMuleEvent;

    @Test
    public void plainTextValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("attributeEvaluator");
        Mockito.when((Object)this.mockExpressionManager.isExpression("attributeEvaluator")).thenReturn((Object)false);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void expressionValue() {
        String attributeValue = "#[eval:express]";
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void expressionValueNoEvaluator() {
        String attributeValue = "#[express]";
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void parse() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("1#[2]3#[4]5");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParseStartsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[1]234#[5]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void parseStartsAndEndsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[1]#[2]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void parenthesesInExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[(1)]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)attributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)attributeEvaluator.isExpression(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void resolveStringWithObjectReturnValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        String expectedValue = "hi";
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)new StringBuilder("hi"));
        Assert.assertThat((Object)attributeEvaluator.resolveStringValue(this.mockMuleEvent), (Matcher)Is.is((Object)"hi"));
    }

    @Test
    public void resolveIntegerWithNumericStringValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        String expectedValue = "123";
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)"123");
        Assert.assertThat((Object)attributeEvaluator.resolveIntegerValue(this.mockMuleEvent), (Matcher)Is.is((Object)Integer.parseInt("123")));
    }

    @Test
    public void resolveIntegerWithNumericValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        long expectedValue = 1234L;
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)1234L);
        Assert.assertThat((Object)attributeEvaluator.resolveIntegerValue(this.mockMuleEvent), (Matcher)Is.is((Object)1234));
    }

    @Test
    public void resolveBooleanWithBooleanStringValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        String expectedValue = "true";
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)"true");
        Assert.assertThat((Object)attributeEvaluator.resolveBooleanValue(this.mockMuleEvent), (Matcher)Is.is((Object)Boolean.valueOf("true")));
    }

    @Test
    public void resolveBooleanWithBooleanValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        Boolean expectedValue = true;
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)expectedValue);
        Assert.assertThat((Object)attributeEvaluator.resolveBooleanValue(this.mockMuleEvent), (Matcher)Is.is((Object)expectedValue));
    }

    @Test(expected=NumberFormatException.class)
    public void resolveIntegerWithNoNumericValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[expression]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        String value = "abcd";
        Mockito.when((Object)this.mockExpressionManager.evaluate(Mockito.anyString(), (MuleEvent)Mockito.any(MuleEvent.class))).thenReturn((Object)"abcd");
        attributeEvaluator.resolveIntegerValue(this.mockMuleEvent);
    }

    @Test
    public void nullAttributeValue() {
        AttributeEvaluator nullAttributeEvaluator = new AttributeEvaluator(null);
        nullAttributeEvaluator.initialize(this.mockExpressionManager);
        Assert.assertThat((Object)nullAttributeEvaluator.isExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nullAttributeEvaluator.isParseExpression(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nullAttributeEvaluator.resolveValue(this.mockMuleEvent), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)nullAttributeEvaluator.resolveIntegerValue(this.mockMuleEvent), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)nullAttributeEvaluator.resolveStringValue(this.mockMuleEvent), (Matcher)IsNull.nullValue());
    }
}

