/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.xa.Xid;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.queue.XaQueueTxJournalEntry;
import org.mule.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.QueueStore;
import org.mule.util.xa.MuleXid;

public class XaTxQueueTransactionJournalTestCase
extends AbstractMuleContextTestCase {
    public static final Xid TX_ID = new MuleXid(9, new byte[]{1, 2, 3, 4}, new byte[]{5, 6, 7, 8});
    public static final String QUEUE_NAME = "queueName";
    public static final String SOME_VALUE = "some value";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DefaultQueueStore mockQueueInfo = (DefaultQueueStore)Mockito.mock(DefaultQueueStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUpMocks() {
        Mockito.when((Object)this.mockQueueInfo.getName()).thenReturn((Object)QUEUE_NAME);
    }

    @Test
    public void logAddAndRetrieve() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAdd((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)TX_ID).size(), (Matcher)Is.is((Object)1));
        XaQueueTxJournalEntry logEntry = (XaQueueTxJournalEntry)allEntries.get((Object)TX_ID).iterator().next();
        Assert.assertThat((Object)logEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)logEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)logEntry.isAdd(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logAddFirstAndRetrieve() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAddFirst((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)TX_ID).size(), (Matcher)Is.is((Object)1));
        XaQueueTxJournalEntry journalEntry = (XaQueueTxJournalEntry)allEntries.get((Object)TX_ID).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAddFirst(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logRemoveAndRetrieve() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRemove((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)TX_ID).size(), (Matcher)Is.is((Object)1));
        XaQueueTxJournalEntry journalEntry = (XaQueueTxJournalEntry)allEntries.get((Object)TX_ID).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isRemove(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logCommitAndRetrieve() {
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logCommit((Object)TX_ID);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void logRollbackAndRetrieve() {
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRollback((Object)TX_ID);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void logSeveralAddsThenCommitAndRetrieve() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.logCommit((Object)TX_ID);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1001));
    }

    @Test
    public void logSeveralAddsAndRetrieve() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)numberOfOffers));
        Assert.assertThat((Object)allEntries.get((Object)TX_ID).size(), (Matcher)Is.is((Object)numberOfOffers));
        XaQueueTxJournalEntry journalEntry = (XaQueueTxJournalEntry)allEntries.get((Object)TX_ID).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAdd(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logAddAndPrepare() throws Exception {
        MuleEvent muleEvent = XaTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        XaTxQueueTransactionJournal transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAdd((Object)TX_ID, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.logPrepare(TX_ID);
        transactionJournal.close();
        transactionJournal = new XaTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)2));
        Collection values = allEntries.values();
        Assert.assertThat((Object)values.size(), (Matcher)Is.is((Object)2));
        Iterator iterator = values.iterator();
        XaQueueTxJournalEntry addEntry = (XaQueueTxJournalEntry)iterator.next();
        Assert.assertThat((Object)addEntry.isAdd(), (Matcher)Is.is((Object)true));
        XaQueueTxJournalEntry prepareEntry = (XaQueueTxJournalEntry)iterator.next();
        Assert.assertThat((Object)prepareEntry.isPrepare(), (Matcher)Is.is((Object)true));
    }
}

