/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.queue.DualRandomAccessFileQueueStoreDelegate;

@SmallTest
public class DualRandomAccessFileQueueStoreDelegateTestCase
extends AbstractMuleTestCase {
    private static final int MAXIMUM_NUMBER_OF_BYTES = 100;
    @Rule
    public TemporaryFolder workingDirectory = new TemporaryFolder();

    @Test
    public void nameWithInvalidCharacters() throws IOException {
        String[] testNames;
        for (String testName : testNames = new String[]{"test-test", "test:/test", "test?test", "test:\\test", "test:/test", "test&test", "test|test", "seda.queue(post:\\Customer:ApiTest-config.1)", "this$is%a#really/big\\name@that?has<a>lot*of+invalid^characters!this$is%a#really/big\\name@that?has<a>lot*of+invalid^chars!"}) {
            this.createAndDisposeQueue(testName);
        }
    }

    @Test
    public void readQueueFileMessagesInOrder() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.queue.maxlength", String.valueOf(100), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                int lastInsertedMessageIndex = DualRandomAccessFileQueueStoreDelegateTestCase.this.writeDataUntilSecondFileContainsNextMessages();
                DualRandomAccessFileQueueStoreDelegateTestCase.this.verifyNextMessage(lastInsertedMessageIndex);
            }
        });
    }

    @Test
    public void readQueueFileMessagesInOrderWhenControlFileIsCorrupted() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.queue.maxlength", String.valueOf(100), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                int lastInsertedMessageIndex = DualRandomAccessFileQueueStoreDelegateTestCase.this.writeDataUntilSecondFileContainsNextMessages();
                DualRandomAccessFileQueueStoreDelegateTestCase.this.corruptQueueControlData();
                DualRandomAccessFileQueueStoreDelegateTestCase.this.verifyNextMessage(lastInsertedMessageIndex);
            }
        });
    }

    private void corruptQueueControlData() throws IOException {
        DualRandomAccessFileQueueStoreDelegate queueStore = this.createTestQueueStore();
        RandomAccessFile randomAccessFile = queueStore.getQueueControlDataFile().getQueueFileProvider().getRandomAccessFile();
        randomAccessFile.seek(0L);
        randomAccessFile.write(2000);
        queueStore.close();
    }

    private void verifyNextMessage(int lastInsertedMessageIndex) throws InterruptedException {
        DualRandomAccessFileQueueStoreDelegate queueStore = this.createTestQueueStore();
        Assert.assertThat((Object)((String)((Object)queueStore.removeFirst())), (Matcher)Is.is((Object)this.createTestDataForIndex(lastInsertedMessageIndex)));
        queueStore.close();
    }

    private int writeDataUntilSecondFileContainsNextMessages() throws InterruptedException {
        DualRandomAccessFileQueueStoreDelegate queueStore = this.createTestQueueStore();
        File initialReadFile = queueStore.getQueueControlDataFile().getCurrentReadFile();
        int numberOfMessagesCreated = 0;
        do {
            queueStore.add((Serializable)((Object)this.createTestDataForIndex(numberOfMessagesCreated)));
            ++numberOfMessagesCreated;
        } while (queueStore.getQueueControlDataFile().getCurrentWriteFile().getAbsolutePath().equals(initialReadFile.getAbsolutePath()));
        int lastInsertedMessageIndex = numberOfMessagesCreated - 1;
        for (int i = 0; i < lastInsertedMessageIndex; ++i) {
            queueStore.removeFirst();
        }
        queueStore.peek();
        Assert.assertThat((Object)queueStore.getQueueControlDataFile().getCurrentReadFile().getAbsolutePath(), (Matcher)IsNot.not((Object)initialReadFile.getAbsolutePath()));
        Assert.assertThat((Object)queueStore.getQueueControlDataFile().getCurrentWriteFile().getAbsolutePath(), (Matcher)IsNot.not((Object)initialReadFile.getAbsolutePath()));
        queueStore.close();
        return lastInsertedMessageIndex;
    }

    private void createAndDisposeQueue(String queueName) throws IOException {
        DualRandomAccessFileQueueStoreDelegate queue = new DualRandomAccessFileQueueStoreDelegate(queueName, this.workingDirectory.getRoot().getAbsolutePath(), null, 1);
        queue.dispose();
    }

    private String createTestDataForIndex(int numberOfMesagesCreated) {
        return "some value " + numberOfMesagesCreated;
    }

    private DualRandomAccessFileQueueStoreDelegate createTestQueueStore() {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)mockMuleContext.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        return new DualRandomAccessFileQueueStoreDelegate("test-queue", this.workingDirectory.getRoot().getAbsolutePath(), mockMuleContext, 0);
    }
}

