/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.mule.common.metadata.DefaultXmlMetaDataModel;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;
import org.mule.common.metadata.property.DescriptionMetaDataProperty;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;

public class DefaultXmlMetaDataBuilder<P extends MetaDataBuilder<?>>
implements XmlMetaDataBuilder<P> {
    public QName name;
    public List<String> schemas = new ArrayList<String>();
    public List<InputStream> schemasStream = new ArrayList<InputStream>();
    public List<URL> schemasUrls = new ArrayList<URL>();
    public Charset encoding = Charset.forName("UTF-8");
    public String example;
    private String label;
    private String description;
    private URL sourceUrl;

    public DefaultXmlMetaDataBuilder(String name) {
        this(new QName(name));
    }

    public DefaultXmlMetaDataBuilder(QName name) {
        this.name = name;
    }

    @Override
    public XmlMetaDataModel build() {
        MetaDataModel model = null;
        if (this.schemas != null) {
            model = new DefaultXmlMetaDataModel(this.schemas, this.sourceUrl, this.name, this.encoding, new TextBasedExampleMetaDataModelProperty(this.example));
        } else if (this.schemasStream != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (InputStream schemaStream : this.schemasStream) {
                result.add(DefaultXmlMetaDataBuilder.getStringFromInputStream(schemaStream, this.encoding));
            }
            model = new DefaultXmlMetaDataModel(result, this.sourceUrl, this.name, this.encoding, new TextBasedExampleMetaDataModelProperty(this.example));
        } else if (this.schemasUrls != null) {
            model = new DefaultXmlMetaDataModel(this.schemasUrls, this.name, new TextBasedExampleMetaDataModelProperty(this.example));
        }
        if (this.label != null) {
            model.addProperty(new LabelMetaDataProperty(this.label));
        }
        if (this.description != null) {
            model.addProperty(new DescriptionMetaDataProperty(this.description));
        }
        return model;
    }

    private static String getStringFromInputStream(InputStream is, Charset encoding) {
        try {
            if (encoding != null) {
                return IOUtils.toString((InputStream)is, (String)encoding.toString());
            }
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to turn input stream into string with encoding [" + encoding + "]", ex);
        }
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setSourceUri(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaStringList(String ... schemas) {
        this.schemas.addAll(Arrays.asList(schemas));
        this.schemasStream = null;
        this.schemasUrls = null;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaStreamList(InputStream ... schemaStreams) {
        this.schemasStream.addAll(Arrays.asList(schemaStreams));
        this.schemas = null;
        this.schemasUrls = null;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaUrlList(URL ... schemaStreams) {
        this.schemasUrls.addAll(Arrays.asList(schemaStreams));
        this.schemas = null;
        this.schemasStream = null;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setExample(String xmlExample) {
        this.example = xmlExample;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setDescription(String description) {
        this.description = description;
        return this;
    }
}

