/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.processor.DynamicPipeline;
import org.mule.api.processor.DynamicPipelineBuilder;
import org.mule.api.processor.DynamicPipelineException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.NamedStageNameSource;
import org.mule.api.processor.SequentialStageNameSource;
import org.mule.api.processor.StageNameSource;
import org.mule.api.processor.StageNameSourceProvider;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.DynamicPipelineMessageProcessor;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.routing.requestreply.AsyncReplyToPropertyRequestReplyReplier;

public class Flow
extends AbstractPipeline
implements MessageProcessor,
StageNameSourceProvider,
DynamicPipeline {
    private int stageCount = 0;
    private final StageNameSource sequentialStageNameSource;
    private DynamicPipelineMessageProcessor dynamicPipelineMessageProcessor;

    public Flow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.processingStrategy = new DefaultFlowProcessingStrategy();
        this.sequentialStageNameSource = new SequentialStageNameSource(name);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        Object replyToDestination = event.getReplyToDestination();
        ReplyToHandler replyToHandler = event.getReplyToHandler();
        final DefaultMuleEvent newEvent = new DefaultMuleEvent(event, this, null, null);
        RequestContext.setEvent(newEvent);
        try {
            ErrorHandlingExecutionTemplate executionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate(this.muleContext, this.getExceptionListener());
            MuleEvent result = executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                @Override
                public MuleEvent process() throws Exception {
                    MuleEvent result = Flow.this.pipeline.process(newEvent);
                    if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
                        result.getMessage().release();
                    }
                    return result;
                }
            });
            if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
                result = new DefaultMuleEvent(result, event.getFlowConstruct(), replyToHandler, replyToDestination);
            }
            MuleEvent muleEvent = result;
            return muleEvent;
        }
        catch (MessagingException e) {
            e.setProcessedEvent(new DefaultMuleEvent(e.getEvent(), event.getFlowConstruct()));
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.createStaticMessage("Flow execution exception"), (Throwable)e);
        }
        finally {
            RequestContext.setEvent(event);
            event.getMessage().release();
        }
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new AbstractPipeline.ProcessIfPipelineStartedMessageProcessor());
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
        this.dynamicPipelineMessageProcessor = new DynamicPipelineMessageProcessor(this);
        builder.chain(this.dynamicPipelineMessageProcessor);
    }

    @Override
    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new AsyncReplyToPropertyRequestReplyReplier());
        super.configurePostProcessors(builder);
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    @Override
    protected void configureStatistics() {
        this.statistics = this.processingStrategy instanceof AsynchronousProcessingStrategy && ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads() != null ? new FlowConstructStatistics(this.getConstructType(), this.name, ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads()) : new FlowConstructStatistics(this.getConstructType(), this.name);
        if (this.processingStrategy instanceof QueuedAsynchronousProcessingStrategy) {
            ((QueuedAsynchronousProcessingStrategy)this.processingStrategy).setQueueStatistics(this.statistics);
        }
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    @Override
    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.stage%s", Flow.this.getName(), ++Flow.this.stageCount);
            }
        }, builder, this.muleContext);
    }

    @Override
    public StageNameSource getAsyncStageNameSource() {
        return this.sequentialStageNameSource;
    }

    @Override
    public StageNameSource getAsyncStageNameSource(String asyncName) {
        return new NamedStageNameSource(this.name, asyncName);
    }

    @Override
    public DynamicPipelineBuilder dynamicPipeline(String id) throws DynamicPipelineException {
        return this.dynamicPipelineMessageProcessor.dynamicPipeline(id);
    }
}

