/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.processor.InternalMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;

public class NotificationUtils {
    private NotificationUtils() {
    }

    public static void addMessageProcessorPathElements(List<MessageProcessor> processors, MessageProcessorPathElement parentElement) {
        if (processors == null) {
            return;
        }
        for (MessageProcessor mp : processors) {
            if (mp instanceof InternalMessageProcessor) continue;
            MessageProcessorPathElement messageProcessorPathElement = parentElement.addChild(mp);
            if (!(mp instanceof MessageProcessorContainer)) continue;
            ((MessageProcessorContainer)((Object)mp)).addMessageProcessorPathElements(messageProcessorPathElement);
        }
    }

    public static Map<MessageProcessor, String> buildPaths(MessageProcessorPathElement element) {
        return NotificationUtils.buildPaths(element, new LinkedHashMap<MessageProcessor, String>());
    }

    private static Map<MessageProcessor, String> buildPaths(MessageProcessorPathElement element, Map<MessageProcessor, String> elements) {
        if (element.getMessageProcessor() != null) {
            elements.put(element.getMessageProcessor(), element.getPath());
        }
        List<MessageProcessorPathElement> children = element.getChildren();
        for (MessageProcessorPathElement child : children) {
            NotificationUtils.buildPaths(child, elements);
        }
        return elements;
    }
}

