/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.util.annotation.AnnotationMetaData;

public class AnnotationUtils {
    public static boolean methodHasParamAnnotations(Method method) {
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            if (method.getParameterAnnotations()[i].length <= 0) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationMetaData> getParamAnnotations(Method method) {
        return AnnotationUtils.getParamAnnotationsWithMeta(method, null);
    }

    public static List<AnnotationMetaData> getParamAnnotationsWithMeta(Method method, Class<? extends Annotation> metaAnnotation) {
        ArrayList<AnnotationMetaData> annos = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            for (int j = 0; j < method.getParameterAnnotations()[i].length; ++j) {
                Annotation annotation = method.getParameterAnnotations()[i][j];
                if (metaAnnotation != null && !annotation.annotationType().isAnnotationPresent(metaAnnotation)) continue;
                annos.add(new AnnotationMetaData(method.getDeclaringClass(), method, ElementType.PARAMETER, annotation));
            }
        }
        return annos;
    }

    public static List<AnnotationMetaData> getClassAndMethodAnnotations(Class<?> c) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getAnnotations().length; ++i) {
            annotations.add(new AnnotationMetaData(c, null, ElementType.TYPE, c.getAnnotations()[i]));
        }
        annotations.addAll(AnnotationUtils.getAllMethodAnnotations(c));
        return annotations;
    }

    public static List<AnnotationMetaData> getAllMethodAnnotations(Class<?> c) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getMethods().length; ++i) {
            Method method = c.getMethods()[i];
            for (int j = 0; j < method.getDeclaredAnnotations().length; ++j) {
                annotations.add(new AnnotationMetaData(c, method, ElementType.METHOD, method.getDeclaredAnnotations()[j]));
            }
        }
        return annotations;
    }

    public static List<AnnotationMetaData> getMethodAnnotations(Class<?> c, Class<? extends Annotation> ann) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getMethods().length; ++i) {
            Method method = c.getMethods()[i];
            for (int j = 0; j < method.getDeclaredAnnotations().length; ++j) {
                if (!ann.isInstance(method.getDeclaredAnnotations()[j])) continue;
                annotations.add(new AnnotationMetaData(c, method, ElementType.METHOD, method.getDeclaredAnnotations()[j]));
            }
        }
        return annotations;
    }

    public static List<AnnotationMetaData> getMethodMetaAnnotations(Class<?> c, Class<? extends Annotation> metaAnn) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getMethods().length; ++i) {
            Method method = c.getMethods()[i];
            for (int j = 0; j < method.getDeclaredAnnotations().length; ++j) {
                if (!method.getDeclaredAnnotations()[j].annotationType().isAnnotationPresent(metaAnn)) continue;
                annotations.add(new AnnotationMetaData(c, method, ElementType.METHOD, method.getDeclaredAnnotations()[j]));
            }
        }
        return annotations;
    }

    public static List<AnnotationMetaData> getAllFieldAnnotations(Class<?> c) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getDeclaredFields().length; ++i) {
            Field field = c.getDeclaredFields()[i];
            for (int j = 0; j < field.getDeclaredAnnotations().length; ++j) {
                annotations.add(new AnnotationMetaData(c, field, ElementType.FIELD, field.getDeclaredAnnotations()[j]));
            }
        }
        return annotations;
    }

    public static List<AnnotationMetaData> getFieldAnnotations(Class<?> c, Class<? extends Annotation> annotation) {
        ArrayList<AnnotationMetaData> annotations = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < c.getDeclaredFields().length; ++i) {
            Field field = c.getDeclaredFields()[i];
            for (int j = 0; j < field.getDeclaredAnnotations().length; ++j) {
                if (!annotation.equals(field.getDeclaredAnnotations()[j].annotationType())) continue;
                annotations.add(new AnnotationMetaData(c, field, ElementType.FIELD, field.getDeclaredAnnotations()[j]));
            }
        }
        return annotations;
    }

    @Deprecated
    public static AnnotationMetaData getClassAnnotationInHeirarchy(Class<? extends Annotation> annotation, Class<?> bottom) {
        return AnnotationUtils.getClassAnnotationInHierarchy(annotation, bottom);
    }

    public static AnnotationMetaData getClassAnnotationInHierarchy(Class<? extends Annotation> annotation, Class<?> bottom) {
        AnnotationMetaData anno = AnnotationUtils.getClassAnnotationForSuperClasses(annotation, bottom);
        if (anno == null) {
            for (int i = 0; i < bottom.getInterfaces().length; ++i) {
                Class<?> aClass = bottom.getInterfaces()[i];
                if (!aClass.isAnnotationPresent(annotation)) continue;
                anno = new AnnotationMetaData(aClass, null, ElementType.TYPE, aClass.getAnnotation(annotation));
                break;
            }
        }
        return anno;
    }

    @Deprecated
    public static List<AnnotationMetaData> getClassAnnotationInHeirarchy(Class<?> bottom) {
        return AnnotationUtils.getClassAnnotationInHierarchy(bottom);
    }

    public static List<AnnotationMetaData> getClassAnnotationInHierarchy(Class<?> bottom) {
        ArrayList<AnnotationMetaData> annos = new ArrayList<AnnotationMetaData>();
        AnnotationUtils.getClassAnnotationForSuperClasses(bottom, annos);
        AnnotationUtils.getClassAnnotationForInterfaces(bottom, annos);
        return annos;
    }

    protected static AnnotationMetaData getClassAnnotationForSuperClasses(Class<? extends Annotation> annotation, Class<?> bottom) {
        if (bottom.isAnnotationPresent(annotation)) {
            return new AnnotationMetaData(bottom, null, ElementType.TYPE, bottom.getAnnotation(annotation));
        }
        if (bottom.getSuperclass() != null && !bottom.getSuperclass().equals(Object.class)) {
            return AnnotationUtils.getClassAnnotationForSuperClasses(annotation, bottom.getSuperclass());
        }
        return null;
    }

    protected static void getClassAnnotationForSuperClasses(Class<?> bottom, List<AnnotationMetaData> annos) {
        for (Annotation annotation : bottom.getAnnotations()) {
            annos.add(new AnnotationMetaData(bottom, null, ElementType.TYPE, annotation));
        }
        if (bottom.getSuperclass() != null && !bottom.getSuperclass().equals(Object.class)) {
            AnnotationUtils.getClassAnnotationForSuperClasses(bottom.getSuperclass(), annos);
        }
    }

    protected static void getClassAnnotationForInterfaces(Class<?> bottom, List<AnnotationMetaData> annos) {
        for (Class<?> aClass : bottom.getInterfaces()) {
            for (Annotation annotation : aClass.getAnnotations()) {
                annos.add(new AnnotationMetaData(bottom, null, ElementType.TYPE, annotation));
            }
        }
    }

    @Deprecated
    public static Set<AnnotationMetaData> getFieldAnnotationsForHeirarchy(Class<?> bottom) {
        return AnnotationUtils.getFieldAnnotationsForHierarchy(bottom);
    }

    public static Set<AnnotationMetaData> getFieldAnnotationsForHierarchy(Class<?> bottom) {
        HashSet<AnnotationMetaData> annos = new HashSet<AnnotationMetaData>();
        AnnotationUtils.getFieldAnnotationsForSuperClasses(bottom, annos);
        AnnotationUtils.getFieldAnnotationsForInterfaces(bottom, annos);
        return annos;
    }

    public static void getFieldAnnotationsForInterfaces(Class<?> clazz, Set<AnnotationMetaData> annos) {
        for (int i = 0; i < clazz.getInterfaces().length; ++i) {
            Class<?> aClass = clazz.getInterfaces()[i];
            annos.addAll(AnnotationUtils.getAllFieldAnnotations(aClass));
            AnnotationUtils.getFieldAnnotationsForInterfaces(aClass, annos);
        }
    }

    protected static void getFieldAnnotationsForSuperClasses(Class<?> bottom, Set<AnnotationMetaData> annos) {
        annos.addAll(AnnotationUtils.getAllFieldAnnotations(bottom));
        if (bottom.getSuperclass() != null && !bottom.getSuperclass().equals(Object.class)) {
            AnnotationUtils.getFieldAnnotationsForSuperClasses(bottom.getSuperclass(), annos);
        }
    }

    @Deprecated
    public static Set<AnnotationMetaData> getFieldAnnotationsForHeirarchy(Class<?> bottom, Class<? extends Annotation> annotation) {
        return AnnotationUtils.getFieldAnnotationsForHierarchy(bottom, annotation);
    }

    public static Set<AnnotationMetaData> getFieldAnnotationsForHierarchy(Class<?> bottom, Class<? extends Annotation> annotation) {
        HashSet<AnnotationMetaData> annos = new HashSet<AnnotationMetaData>();
        AnnotationUtils.getFieldAnnotationsForSuperClasses(bottom, annos, annotation);
        AnnotationUtils.getFieldAnnotationsForInterfaces(bottom, annos, annotation);
        return annos;
    }

    public static void getFieldAnnotationsForInterfaces(Class<?> clazz, Set<AnnotationMetaData> annos, Class<? extends Annotation> annotation) {
        for (int i = 0; i < clazz.getInterfaces().length; ++i) {
            Class<?> aClass = clazz.getInterfaces()[i];
            annos.addAll(AnnotationUtils.getFieldAnnotations(aClass, annotation));
            AnnotationUtils.getFieldAnnotationsForInterfaces(aClass, annos, annotation);
        }
    }

    protected static void getFieldAnnotationsForSuperClasses(Class<?> bottom, Set<AnnotationMetaData> annos, Class<? extends Annotation> annotation) {
        annos.addAll(AnnotationUtils.getFieldAnnotations(bottom, annotation));
        if (bottom.getSuperclass() != null && !bottom.getSuperclass().equals(Object.class)) {
            AnnotationUtils.getFieldAnnotationsForSuperClasses(bottom.getSuperclass(), annos, annotation);
        }
    }

    public static boolean hasAnnotation(Class<? super Annotation> annotation, Class<?> clazz) throws IOException {
        for (Annotation anno : clazz.getDeclaredAnnotations()) {
            if (!anno.annotationType().getName().equals(clazz.getName())) continue;
            return true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation anno : field.getDeclaredAnnotations()) {
                if (!anno.annotationType().getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation anno : method.getDeclaredAnnotations()) {
                if (!anno.annotationType().getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotationWithPackage(String packageName, Class<?> clazz) throws IOException {
        for (Annotation anno : clazz.getDeclaredAnnotations()) {
            if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
            return true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation anno : field.getDeclaredAnnotations()) {
                if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
                return true;
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation anno : method.getDeclaredAnnotations()) {
                if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

