/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpFileArchiveInputStream;
import org.mule.transport.sftp.SftpInputStream;
import org.mule.transport.sftp.SftpUtil;
import org.mule.transport.sftp.notification.SftpNotifier;
import org.mule.util.FileUtils;

public class SftpReceiverRequesterUtil {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private final SftpConnector connector;
    private final ImmutableEndpoint endpoint;
    private final FilenameFilter filenameFilter;
    private final SftpUtil sftpUtil;

    public SftpReceiverRequesterUtil(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (SftpConnector)endpoint.getConnector();
        this.sftpUtil = new SftpUtil(endpoint);
        this.filenameFilter = endpoint.getFilter() instanceof FilenameFilter ? (FilenameFilter)endpoint.getFilter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableFiles(boolean onlyGetTheFirstOne) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking files at endpoint " + this.endpoint.getEndpointURI()));
        }
        SftpClient client = null;
        try {
            client = this.connector.createSftpClient(this.endpoint);
            long fileAge = this.connector.getFileAge();
            boolean checkFileAge = this.connector.getCheckFileAge();
            if (this.endpoint.getProperty((Object)"fileAge") != null) {
                checkFileAge = true;
                fileAge = Long.valueOf((String)this.endpoint.getProperty((Object)"fileAge"));
            }
            this.logger.debug((Object)("fileAge : " + fileAge));
            long sizeCheckDelayMs = this.sftpUtil.getSizeCheckWaitTime();
            String[] files = client.listFiles();
            ArrayList<String> completedFiles = new ArrayList<String>(files.length);
            for (String file : files) {
                if (this.filenameFilter != null && !this.filenameFilter.accept(null, file)) continue;
                if (checkFileAge || sizeCheckDelayMs >= 0L) {
                    if (!this.canProcessFile(file, client, fileAge, sizeCheckDelayMs)) continue;
                    completedFiles.add(file);
                    if (!onlyGetTheFirstOne) continue;
                    break;
                }
                completedFiles.add(file);
                if (onlyGetTheFirstOne) break;
            }
            String[] stringArray = completedFiles.toArray(new String[completedFiles.size()]);
            return stringArray;
        }
        finally {
            if (client != null) {
                this.connector.releaseClient(this.endpoint, client);
            }
        }
    }

    public InputStream retrieveFile(String fileName, SftpNotifier notifier) throws Exception {
        SftpClient client = this.connector.createSftpClient(this.endpoint, notifier);
        String tmpSendingDir = this.sftpUtil.getTempDirInbound();
        if (tmpSendingDir != null) {
            boolean addUniqueSuffix = this.sftpUtil.isUseTempFileTimestampSuffix();
            client.createSftpDirIfNotExists(this.endpoint, tmpSendingDir);
            String tmpSendingFileName = tmpSendingDir + "/" + fileName;
            if (addUniqueSuffix) {
                tmpSendingFileName = this.sftpUtil.createUniqueSuffix(tmpSendingFileName);
            }
            String fullTmpSendingPath = this.endpoint.getEndpointURI().getPath() + "/" + tmpSendingFileName;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Move " + fileName + " to " + fullTmpSendingPath));
            }
            client.rename(fileName, fullTmpSendingPath);
            fileName = tmpSendingFileName;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Move done");
            }
        }
        String archive = this.sftpUtil.getArchiveDir();
        InputStream fileInputStream = client.retrieveFile(fileName);
        if (!"".equals(archive)) {
            String archiveTmpReceivingDir = this.sftpUtil.getArchiveTempReceivingDir();
            String archiveTmpSendingDir = this.sftpUtil.getArchiveTempSendingDir();
            SftpInputStream is = new SftpInputStream(client, fileInputStream, fileName, this.connector.isAutoDelete(), this.endpoint);
            int idx = fileName.lastIndexOf(47);
            String fileNamePart = fileName.substring(idx + 1);
            File archiveFile = FileUtils.newFile((String)archive, (String)fileNamePart);
            if ("".equals(archiveTmpReceivingDir) || "".equals(archiveTmpSendingDir)) {
                return this.archiveFile(is, archiveFile);
            }
            return this.archiveFileUsingTempDirs(archive, archiveTmpReceivingDir, archiveTmpSendingDir, is, fileNamePart, archiveFile);
        }
        return new SftpInputStream(client, fileInputStream, fileName, this.connector.isAutoDelete(), this.endpoint);
    }

    private InputStream archiveFileUsingTempDirs(String archive, String archiveTmpReceivingDir, String archiveTmpSendingDir, InputStream is, String fileNamePart, File archiveFile) throws IOException {
        File archiveTmpReceivingFolder = FileUtils.newFile((String)(archive + '/' + archiveTmpReceivingDir));
        File archiveTmpReceivingFile = FileUtils.newFile((String)(archive + '/' + archiveTmpReceivingDir), (String)fileNamePart);
        if (!archiveTmpReceivingFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveTmpReceivingFolder.getAbsolutePath()));
            }
            if (!archiveTmpReceivingFolder.mkdirs()) {
                throw new IOException("Failed to create archive-tmp-receiving-folder: " + archiveTmpReceivingFolder);
            }
        }
        File archiveTmpSendingFolder = FileUtils.newFile((String)(archive + '/' + archiveTmpSendingDir));
        File archiveTmpSendingFile = FileUtils.newFile((String)(archive + '/' + archiveTmpSendingDir), (String)fileNamePart);
        if (!archiveTmpSendingFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveTmpSendingFolder.getAbsolutePath()));
            }
            if (!archiveTmpSendingFolder.mkdirs()) {
                throw new IOException("Failed to create archive-tmp-sending-folder: " + archiveTmpSendingFolder);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Copy SftpInputStream to archiveTmpReceivingFile... " + archiveTmpReceivingFile.getAbsolutePath()));
        }
        this.sftpUtil.copyStreamToFile(is, archiveTmpReceivingFile);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Move archiveTmpReceivingFile (" + archiveTmpReceivingFile + ") to archiveTmpSendingFile (" + archiveTmpSendingFile + ")..."));
        }
        FileUtils.moveFile((File)archiveTmpReceivingFile, (File)archiveTmpSendingFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Return SftpFileArchiveInputStream for archiveTmpSendingFile (" + archiveTmpSendingFile + ")..."));
        }
        return new SftpFileArchiveInputStream(archiveTmpSendingFile, archiveFile);
    }

    private InputStream archiveFile(InputStream is, File archiveFile) throws IOException {
        File archiveFolder = FileUtils.newFile((String)archiveFile.getParentFile().getPath());
        if (!archiveFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveFolder.getAbsolutePath()));
            }
            if (!archiveFolder.mkdirs()) {
                throw new IOException("Failed to create archive-folder: " + archiveFolder);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Copy SftpInputStream to archiveFile... " + archiveFile.getAbsolutePath()));
        }
        this.sftpUtil.copyStreamToFile(is, archiveFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"*** Return SftpFileArchiveInputStream for archiveFile...");
        }
        return new SftpFileArchiveInputStream(archiveFile);
    }

    protected boolean canProcessFile(String fileName, SftpClient client, long fileAge, long sizeCheckDelayMs) throws Exception {
        if (fileAge > 0L && !this.isOldFile(fileName, client, fileAge)) {
            return false;
        }
        return sizeCheckDelayMs <= 0L || !this.isSizeModified(fileName, client, sizeCheckDelayMs);
    }

    private boolean isSizeModified(String fileName, SftpClient client, long sizeCheckDelayMs) throws IOException, InterruptedException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Perform size check with a delay of: " + sizeCheckDelayMs + " ms."));
            }
            long fileSize1 = client.getSize(fileName);
            Thread.sleep(sizeCheckDelayMs);
            long fileSize2 = client.getSize(fileName);
            if (fileSize1 == fileSize2) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("File is stable (not growing), ready for retrieval: " + fileName));
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("File is growing, deferring retrieval: " + fileName));
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Cannot check if size of file '%s' was modified or not", fileName));
            }
            return true;
        }
    }

    private boolean isOldFile(String fileName, SftpClient client, long fileAge) throws IOException {
        try {
            long lastModifiedTime = client.getLastModifiedTime(fileName);
            long now = System.currentTimeMillis();
            long diff = now - lastModifiedTime;
            if (diff < fileAge) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + fileName + ". The file must be " + (fileAge - diff) + "ms older, was " + diff));
                }
                return false;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The file " + fileName + " has aged enough. Was " + diff));
            }
            return true;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Cannot check if age of file '%s' is old enough", fileName));
            }
            return false;
        }
    }
}

