/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.util.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CryptoFactory {
    private static final Log LOG = LogFactory.getLog(CryptoFactory.class);
    private static final Class<? extends Crypto> DEFAULT_CRYPTO_CLASS = Merlin.class;

    public static Crypto getInstance() throws WSSecurityException {
        return CryptoFactory.getInstance("crypto.properties");
    }

    public static Crypto getInstance(Properties properties) throws WSSecurityException {
        return CryptoFactory.getInstance(properties, Loader.getClassLoader(CryptoFactory.class));
    }

    public static Crypto getInstance(Properties properties, ClassLoader classLoader) throws WSSecurityException {
        String cryptoClassName = properties.getProperty("org.apache.ws.security.crypto.provider");
        Class<? extends Crypto> cryptoClass = null;
        if (cryptoClassName == null || cryptoClassName.equals("org.apache.ws.security.components.crypto.Merlin")) {
            cryptoClass = DEFAULT_CRYPTO_CLASS;
        } else {
            try {
                cryptoClass = Loader.loadClass(cryptoClassName, Crypto.class);
            }
            catch (ClassNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                }
                throw new WSSecurityException(cryptoClassName + " Not Found", ex);
            }
        }
        return CryptoFactory.loadClass(cryptoClass, properties, classLoader);
    }

    public static Crypto getInstance(Class<? extends Crypto> cryptoClass, Map<Object, Object> map) throws WSSecurityException {
        return CryptoFactory.loadClass(cryptoClass, map, Loader.getClassLoader(CryptoFactory.class));
    }

    public static Crypto getInstance(String propFilename) throws WSSecurityException {
        return CryptoFactory.getInstance(propFilename, Loader.getClassLoader(CryptoFactory.class));
    }

    public static Crypto getInstance(String propFilename, ClassLoader customClassLoader) throws WSSecurityException {
        Properties properties = CryptoFactory.getProperties(propFilename, customClassLoader);
        return CryptoFactory.getInstance(properties, customClassLoader);
    }

    private static Crypto loadClass(Class<? extends Crypto> cryptoClass, Map<Object, Object> map, ClassLoader loader) throws WSSecurityException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using Crypto Engine [" + cryptoClass + "]"));
        }
        try {
            Class[] classes = new Class[]{Map.class, ClassLoader.class};
            Constructor<? extends Crypto> c = cryptoClass.getConstructor(classes);
            return c.newInstance(map, loader);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to instantiate: " + cryptoClass.getName()), (Throwable)e);
            }
            throw new WSSecurityException(cryptoClass + " cannot create instance", e);
        }
    }

    private static Crypto loadClass(Class<? extends Crypto> cryptoClass, Properties map, ClassLoader loader) throws WSSecurityException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using Crypto Engine [" + cryptoClass + "]"));
        }
        try {
            Class[] classes = new Class[]{Properties.class, ClassLoader.class};
            Constructor<? extends Crypto> c = cryptoClass.getConstructor(classes);
            return c.newInstance(map, loader);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to instantiate: " + cryptoClass.getName()), (Throwable)e);
            }
            throw new WSSecurityException(cryptoClass + " cannot create instance", e);
        }
    }

    private static Properties getProperties(String propFilename, ClassLoader loader) throws WSSecurityException {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(loader, propFilename);
            if (url == null) {
                throw new WSSecurityException(0, "resourceNotFound", new Object[]{propFilename});
            }
            properties.load(url.openStream());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot find resource: " + propFilename), (Throwable)e);
            }
            throw new WSSecurityException(0, "resourceNotFound", new Object[]{propFilename}, e);
        }
        return properties;
    }
}

