/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.cmd.VariablesCmd;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartProcessInstanceInLatestCmd
extends VariablesCmd<ProcessInstance> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String executionKey;

    public StartProcessInstanceInLatestCmd(String processDefinitionKey, Map<String, ?> variables, String executionKey) {
        if (processDefinitionKey == null) {
            throw new JbpmException("processDefinitionKey is null");
        }
        this.processDefinitionKey = processDefinitionKey;
        this.executionKey = executionKey;
        this.setVariables(variables);
    }

    public ProcessInstance execute(Environment environment) throws Exception {
        ProcessDefinitionImpl processDefinition = null;
        RepositorySession repositorySession = (RepositorySession)environment.get(RepositorySession.class);
        processDefinition = repositorySession.findProcessDefinitionByKey(this.processDefinitionKey);
        if (processDefinition == null) {
            throw new JbpmException("no process definition with key '" + this.processDefinitionKey + "'");
        }
        ClientProcessInstance processInstance = processDefinition.createProcessInstance(this.executionKey);
        processInstance.setVariables(this.variables);
        processInstance.start();
        return processInstance;
    }

    public String getExecutionKey() {
        return this.executionKey;
    }

    public void setExecutionKey(String executionKey) {
        this.executionKey = executionKey;
    }
}

