/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleMessage;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.protocols.DirectProtocol;
import org.mule.transport.tcp.protocols.ProtocolStream;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.SerializationUtils;

public abstract class AbstractByteProtocol
implements TcpProtocol {
    private static final Log logger = LogFactory.getLog(DirectProtocol.class);
    private static final long PAUSE_PERIOD = 100L;
    public static final int EOF = -1;
    public static final boolean STREAM_OK = true;
    public static final boolean NO_STREAM = false;
    private boolean streamOk;
    private boolean rethrowExceptionOnRead = false;

    public AbstractByteProtocol(boolean streamOk) {
        this.streamOk = streamOk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(OutputStream os, Object data) throws IOException {
        if (data instanceof InputStream) {
            if (!this.streamOk) throw new IOException("TCP protocol " + ClassUtils.getSimpleName(this.getClass()) + " cannot handle streaming");
            InputStream is = (InputStream)data;
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            os.flush();
            os.close();
            is.close();
            return;
        } else if (data instanceof MuleMessage) {
            this.write(os, ((MuleMessage)data).getPayload());
            return;
        } else if (data instanceof byte[]) {
            this.writeByteArray(os, (byte[])data);
            return;
        } else if (data instanceof String) {
            this.writeByteArray(os, ((String)data).getBytes());
            return;
        } else {
            if (!(data instanceof Serializable)) throw new IllegalArgumentException("Cannot serialize data: " + data);
            this.writeByteArray(os, SerializationUtils.serialize((Serializable)((Serializable)data)));
        }
    }

    protected void writeByteArray(OutputStream os, byte[] data) throws IOException {
        os.write(data);
    }

    protected int safeRead(InputStream is, byte[] buffer) throws IOException {
        return this.safeRead(is, buffer, buffer.length);
    }

    protected int safeRead(InputStream is, byte[] buffer, int size) throws IOException {
        try {
            int len;
            do {
                if (0 != (len = is.read(buffer, 0, size))) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (0 == len);
            return len;
        }
        catch (SocketException e) {
            logger.info((Object)("Socket exception occured: " + e.getMessage()));
            if (this.rethrowExceptionOnRead) {
                throw e;
            }
            return -1;
        }
        catch (SocketTimeoutException e) {
            logger.debug((Object)"Socket timeout.");
            if (this.rethrowExceptionOnRead) {
                throw e;
            }
            return -1;
        }
    }

    protected int copy(InputStream source, byte[] buffer, OutputStream dest) throws IOException {
        return this.copy(source, buffer, dest, buffer.length);
    }

    protected int copy(InputStream source, byte[] buffer, OutputStream dest, int size) throws IOException {
        int len = this.safeRead(source, buffer, size);
        if (len > 0) {
            dest.write(buffer, 0, len);
        }
        return len;
    }

    protected byte[] nullEmptyArray(byte[] data) {
        if (0 == data.length) {
            return null;
        }
        return data;
    }

    @Override
    public ResponseOutputStream createResponse(Socket socket) throws IOException {
        return new ResponseOutputStream(socket, (OutputStream)new ProtocolStream(this, this.streamOk, socket.getOutputStream()));
    }

    public boolean isRethrowExceptionOnRead() {
        return this.rethrowExceptionOnRead;
    }

    public void setRethrowExceptionOnRead(boolean rethrowExceptionOnRead) {
        this.rethrowExceptionOnRead = rethrowExceptionOnRead;
    }
}

