/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.junit.Assert;
import org.junit.Test;
import org.mule.lifecycle.JSR250ObjectLifecycleTracker;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class JSR250ObjectLifcycleTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testNormalBehaviour() throws Exception {
        JSR250ObjectLifecycleTracker tracker = new JSR250ObjectLifecycleTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testTwoPostConstructAnnotations() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new DupePostConstructJSR250ObjectLifecycleTracker());
            Assert.fail((String)"Object has two @PostConstruct annotations");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoPreDestroyAnnotations() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new DupePreDestroyJSR250ObjectLifecycleTracker());
            Assert.fail((String)"Object has two @PreDestroy annotations");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBadReturnTypePostConstructMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadReturnTypePostConstructLifecycleMethodObject());
            Assert.fail((String)"PostContruct Lifecycle method has a non-void return type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBadParamPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadParamPreDestroyLifecycleMethodObject());
            Assert.fail((String)"PreDestroy Lifecycle method has a parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBadStaticPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadStaticMethodPostConstructLifecycleMethodObject());
            Assert.fail((String)"PostConstruct Lifecycle method is static");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBadCheckedExceptionPreDestroyMethod() throws Exception {
        try {
            muleContext.getRegistry().registerObject("test", (Object)new BadCheckedExceptionPreDestroyLifecycleMethodObject());
            Assert.fail((String)"PreDestroy Lifecycle method throws a checked exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public class BadCheckedExceptionPreDestroyLifecycleMethodObject {
        @PreDestroy
        public void destroy() throws Exception {
        }
    }

    public static class BadStaticMethodPostConstructLifecycleMethodObject {
        @PostConstruct
        public static void init() {
        }
    }

    public class BadParamPreDestroyLifecycleMethodObject {
        @PreDestroy
        public void destroy(boolean foo) {
        }
    }

    public class BadReturnTypePostConstructLifecycleMethodObject {
        @PostConstruct
        public boolean init() {
            return true;
        }
    }

    public class DupePreDestroyJSR250ObjectLifecycleTracker
    extends JSR250ObjectLifecycleTracker {
        @PreDestroy
        public void dispose2() {
            this.getTracker().add("dispose 2");
        }
    }

    public class DupePostConstructJSR250ObjectLifecycleTracker
    extends JSR250ObjectLifecycleTracker {
        @PostConstruct
        public void init2() {
            this.getTracker().add("initialise 2");
        }
    }
}

