/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.CopyPropertiesTransformer;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CopyPropertiesTransformerTest
extends AbstractMuleTestCase {
    public static final String ENCODING = "encoding";
    public static final String INBOUND_PROPERTY_KEY = "propKey";
    private static final Object PROPERTY_VALUE = new Object();
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private MuleMessage mockMuleMessage;
    @Mock
    private ExpressionManager mockExpressionManager;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
    }

    @Test
    public void testCopySingleProperty() throws TransformerException, InitialisationException {
        CopyPropertiesTransformer copyPropertiesTransformer = new CopyPropertiesTransformer();
        copyPropertiesTransformer.setMuleContext(this.mockMuleContext);
        copyPropertiesTransformer.setPropertyName(INBOUND_PROPERTY_KEY);
        copyPropertiesTransformer.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty(INBOUND_PROPERTY_KEY)).thenReturn(PROPERTY_VALUE);
        copyPropertiesTransformer.transform((Object)this.mockMuleMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage)).getInboundProperty(INBOUND_PROPERTY_KEY);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage)).setOutboundProperty(INBOUND_PROPERTY_KEY, PROPERTY_VALUE);
    }

    @Test
    public void testCopyNonExistentProperty() throws TransformerException, InitialisationException {
        CopyPropertiesTransformer copyPropertiesTransformer = new CopyPropertiesTransformer();
        copyPropertiesTransformer.setMuleContext(this.mockMuleContext);
        copyPropertiesTransformer.setPropertyName(INBOUND_PROPERTY_KEY);
        copyPropertiesTransformer.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty(INBOUND_PROPERTY_KEY)).thenReturn(null);
        copyPropertiesTransformer.transform((Object)this.mockMuleMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage, (VerificationMode)VerificationModeFactory.times((int)0))).setOutboundProperty(Matchers.anyString(), Matchers.anyObject());
    }

    @Test
    @Ignore
    public void testCopyUsingRegex() throws InitialisationException, TransformerException {
        CopyPropertiesTransformer copyPropertiesTransformer = new CopyPropertiesTransformer();
        copyPropertiesTransformer.setMuleContext(this.mockMuleContext);
        copyPropertiesTransformer.setPropertyName("MULE_(.*)");
        copyPropertiesTransformer.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundPropertyNames()).thenReturn(new HashSet<String>(Arrays.asList("MULE_ID", "MULE_CORRELATION_ID", "SomeVar", "MULE_GROUP_ID")));
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("MULE_ID")).thenReturn(PROPERTY_VALUE);
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("MULE_CORRELATION_ID")).thenReturn(PROPERTY_VALUE);
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("MULE_GROUP_ID")).thenReturn(PROPERTY_VALUE);
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("SomeVar")).thenReturn(PROPERTY_VALUE);
        copyPropertiesTransformer.transform((Object)this.mockMuleMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage, (VerificationMode)VerificationModeFactory.times((int)0))).setOutboundProperty("SomeVar", PROPERTY_VALUE);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage)).setOutboundProperty("MULE_ID", PROPERTY_VALUE);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage)).setOutboundProperty("MULE_CORRELATION_ID", PROPERTY_VALUE);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage)).setOutboundProperty("MULE_GROUP_ID", PROPERTY_VALUE);
    }
}

