/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.monitor.Expirable;
import org.mule.util.monitor.ExpiryMonitor;

public class ExpiryMonitorTestCase
extends AbstractMuleTestCase {
    private boolean expired = false;

    protected void doSetUp() throws Exception {
        this.expired = false;
    }

    @Test
    public void testExpiry() throws InterruptedException {
        ExpiryMonitor monitor = new ExpiryMonitor("test", 100, null, false);
        Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expired = true;
            }
        };
        monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        Thread.sleep(800L);
        Assert.assertTrue((boolean)this.expired);
        Assert.assertTrue((!monitor.isRegistered(e) ? 1 : 0) != 0);
    }

    @Test
    public void testNotExpiry() throws InterruptedException {
        ExpiryMonitor monitor = new ExpiryMonitor("test", 100, null, false);
        Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expired = true;
            }
        };
        monitor.addExpirable(800L, TimeUnit.MILLISECONDS, e);
        Thread.sleep(300L);
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        Thread.sleep(800L);
        Assert.assertTrue((boolean)this.expired);
        Assert.assertTrue((!monitor.isRegistered(e) ? 1 : 0) != 0);
    }

    @Test
    public void testExpiryWithReset() throws InterruptedException {
        ExpiryMonitor monitor = new ExpiryMonitor("test", 100, null, false);
        Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expired = true;
            }
        };
        monitor.addExpirable(600L, TimeUnit.MILLISECONDS, e);
        Thread.sleep(200L);
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        monitor.resetExpirable(e);
        Thread.sleep(200L);
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        Thread.sleep(600L);
        Assert.assertTrue((boolean)this.expired);
        Assert.assertTrue((!monitor.isRegistered(e) ? 1 : 0) != 0);
    }

    @Test
    public void testNotExpiryWithRemove() throws InterruptedException {
        ExpiryMonitor monitor = new ExpiryMonitor("test", 100, null, false);
        Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expired = true;
            }
        };
        monitor.addExpirable(1000L, TimeUnit.MILLISECONDS, e);
        Thread.sleep(200L);
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        Thread.sleep(200L);
        monitor.removeExpirable(e);
        Thread.sleep(800L);
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        Assert.assertTrue((!monitor.isRegistered(e) ? 1 : 0) != 0);
    }
}

