/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.mule.api.MuleEvent;
import org.mule.module.cxf.MuleSoapHeaders;
import org.mule.module.cxf.support.AbstractMuleHeaderInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MuleHeadersOutInterceptor
extends AbstractMuleHeaderInterceptor {
    public MuleHeadersOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message m) throws Fault {
        if (!(m instanceof SoapMessage)) {
            return;
        }
        SoapMessage message = (SoapMessage)m;
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"mule.event");
        if (event == null) {
            return;
        }
        MuleSoapHeaders muleHeaders = new MuleSoapHeaders(event);
        if (muleHeaders.getCorrelationId() == null && muleHeaders.getReplyTo() == null) {
            return;
        }
        Document owner_doc = DOMUtils.createDocument();
        Element mule_header = owner_doc.createElementNS("http://www.muleumo.org/providers/soap/1.0", "mule:header");
        mule_header.setAttribute("xmlns:mule", "http://www.muleumo.org/providers/soap/1.0");
        if (muleHeaders.getCorrelationId() != null) {
            mule_header.appendChild(this.buildMuleHeader(owner_doc, "MULE_CORRELATION_ID", muleHeaders.getCorrelationId()));
            mule_header.appendChild(this.buildMuleHeader(owner_doc, "MULE_CORRELATION_GROUP_SIZE", muleHeaders.getCorrelationGroup()));
            mule_header.appendChild(this.buildMuleHeader(owner_doc, "MULE_CORRELATION_SEQUENCE", muleHeaders.getCorrelationSequence()));
        }
        if (muleHeaders.getReplyTo() != null) {
            mule_header.appendChild(this.buildMuleHeader(owner_doc, "MULE_REPLYTO", muleHeaders.getReplyTo()));
        }
        SoapHeader sh = new SoapHeader(new QName("http://www.muleumo.org/providers/soap/1.0", "header"), (Object)mule_header);
        message.getHeaders().add(sh);
    }

    Element buildMuleHeader(Document owner_doc, String localName, String value) {
        Element out = owner_doc.createElementNS("http://www.muleumo.org/providers/soap/1.0", "mule:" + localName);
        if (value != null) {
            Text text = owner_doc.createTextNode(value);
            out.appendChild(text);
        }
        return out;
    }
}

