/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.query;

import java.util.LinkedList;
import java.util.List;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;

public class Query {
    private final QueryTemplate queryTemplate;
    private final List<QueryParamValue> paramValues;

    public Query(QueryTemplate queryTemplate, List<QueryParamValue> paramValues) {
        this.paramValues = paramValues;
        this.queryTemplate = queryTemplate;
    }

    public Query(QueryTemplate queryTemplate) {
        this.queryTemplate = queryTemplate;
        this.paramValues = new LinkedList<QueryParamValue>();
        for (InputQueryParam inputParam : queryTemplate.getInputParams()) {
            QueryParamValue paramValue = new QueryParamValue(inputParam.getName(), inputParam.getValue());
            this.paramValues.add(paramValue);
        }
    }

    public QueryTemplate getQueryTemplate() {
        return this.queryTemplate;
    }

    public List<QueryParamValue> getParamValues() {
        return this.paramValues;
    }

    public boolean isDynamic() {
        return this.queryTemplate.isDynamic();
    }
}

