/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.compiler;

import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.compiler.Compiler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseCompiler
extends Compiler {
    private CompilerOptions compilerOptions;

    public EclipseCompiler() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "generate");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.compilerOptions = new CompilerOptions(settings);
    }

    @Override
    public ClassLoader compile(Map<String, File> sources) {
        HashMap<String, byte[]> byteCode = new HashMap<String, byte[]>();
        CompilerRequestor compilerRequestor = new CompilerRequestor(byteCode);
        org.eclipse.jdt.internal.compiler.Compiler compiler = new org.eclipse.jdt.internal.compiler.Compiler((INameEnvironment)new NameEnvironment(sources, byteCode), DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, (ICompilerRequestor)compilerRequestor, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>(sources.size());
        for (Map.Entry<String, File> entry : sources.entrySet()) {
            compilationUnits.add(new CompilationUnit(entry.getKey(), entry.getValue()));
        }
        compiler.compile(compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]));
        int errorCount = 0;
        if (compilerRequestor.hasErrors()) {
            for (IProblem problem : compilerRequestor.getProblems()) {
                if (problem.isError()) {
                    System.out.println("ERROR " + new String(problem.getOriginatingFileName()) + ":[" + problem.getSourceLineNumber() + "] " + problem.getMessage());
                    ++errorCount;
                    continue;
                }
                System.out.println("WARNING " + new String(problem.getOriginatingFileName()) + ":[" + problem.getSourceLineNumber() + "] " + problem.getMessage());
            }
        }
        if (errorCount > 0) {
            throw new BuildException("Compile completed with " + errorCount + " errors and " + (compilerRequestor.getProblems().size() - errorCount) + " warnings");
        }
        return new MemoryClassLoader(Thread.currentThread().getContextClassLoader(), byteCode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemoryClassLoader
    extends ClassLoader {
        Map<String, byte[]> byteCode;

        private MemoryClassLoader(ClassLoader parent, Map<String, byte[]> byteCode) {
            super(parent);
            this.byteCode = byteCode;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String packageName;
            byte[] bytes = this.byteCode.get(name);
            if (bytes == null) {
                throw new ClassNotFoundException(name);
            }
            int index = name.lastIndexOf(46);
            if (index > 0 && this.getPackage(packageName = name.substring(0, index)) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerRequestor
    implements ICompilerRequestor {
        private boolean hasErrors;
        private final List<IProblem> problems = new ArrayList<IProblem>();
        private final Map<String, byte[]> byteCode;

        private CompilerRequestor(Map<String, byte[]> byteCode) {
            this.byteCode = byteCode;
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public List<IProblem> getProblems() {
            return this.problems;
        }

        public Map<String, byte[]> getByteCode() {
            return this.byteCode;
        }

        public void acceptResult(CompilationResult result) {
            if (result.hasProblems()) {
                if (result.hasErrors()) {
                    this.hasErrors = true;
                }
                this.problems.addAll(Arrays.asList((IProblem[])result.getProblems()));
            }
            if (!result.hasErrors()) {
                ClassFile[] clazzFiles;
                for (ClassFile clazzFile : clazzFiles = result.getClassFiles()) {
                    char[][] compoundName = clazzFile.getCompoundName();
                    StringBuffer clazzName = new StringBuffer();
                    for (char[] part : compoundName) {
                        if (clazzName.length() > 0) {
                            clazzName.append('.');
                        }
                        clazzName.append(part);
                    }
                    this.byteCode.put(clazzName.toString(), clazzFile.getBytes());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameEnvironment
    implements INameEnvironment {
        private final Map<String, File> sources;
        private final Map<String, byte[]> byteCode;

        public NameEnvironment(Map<String, File> sources, Map<String, byte[]> byteCode) {
            this.sources = sources;
            this.byteCode = byteCode;
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < compoundTypeName.length; ++i) {
                if (i != 0) {
                    result.append('.');
                }
                result.append(compoundTypeName[i]);
            }
            return this.findType(result.toString());
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageNames) {
            StringBuffer result = new StringBuffer();
            for (char[] packageName : packageNames) {
                result.append(packageName);
                result.append('.');
            }
            result.append(typeName);
            return this.findType(result.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NameEnvironmentAnswer findType(String className) {
            if (this.isPackage(className)) {
                return null;
            }
            byte[] clazzBytes = this.byteCode.get(className);
            if (clazzBytes != null) {
                char[] fileName = className.toCharArray();
                try {
                    ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                catch (ClassFormatException e) {
                    return null;
                }
            }
            String resourceName = className.replace('.', '/') + ".class";
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (in == null) {
                return null;
            }
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
            try {
                int count;
                while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, count);
                }
                out.flush();
                char[] fileName = className.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(out.toByteArray(), fileName, true);
                NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                return nameEnvironmentAnswer;
            }
            catch (IOException e) {
                NameEnvironmentAnswer nameEnvironmentAnswer = null;
                return nameEnvironmentAnswer;
            }
            catch (ClassFormatException e) {
                NameEnvironmentAnswer nameEnvironmentAnswer = null;
                return nameEnvironmentAnswer;
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException oe) {}
                try {
                    in.close();
                }
                catch (IOException ie) {}
            }
        }

        public boolean isPackage(char[][] parentPackageNames, char[] packageName) {
            StringBuffer result = new StringBuffer();
            if (parentPackageNames != null) {
                for (char[] parentPackageName : parentPackageNames) {
                    result.append(parentPackageName).append('.');
                }
            }
            result.append(packageName);
            return this.isPackage(result.toString());
        }

        public void cleanup() {
        }

        private boolean isPackage(String className) {
            if (this.sources.containsKey(className)) {
                return false;
            }
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
            return in == null;
        }
    }

    private static final class CompilationUnit
    implements ICompilationUnit {
        private final File sourceFile;
        private final char[] typeName;
        private final char[][] packageName;

        CompilationUnit(String className, File sourceFile) {
            this.sourceFile = sourceFile;
            int dot = className.lastIndexOf(46);
            this.typeName = dot > 0 ? className.substring(dot + 1).toCharArray() : className.toCharArray();
            StringTokenizer tokenizer = new StringTokenizer(className, ".");
            this.packageName = new char[tokenizer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = tokenizer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.sourceFile.getName().toCharArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char[] getContents() {
            InputStream in = null;
            try {
                in = new FileInputStream(this.sourceFile);
                StringBuffer sb = new StringBuffer();
                in = new BufferedInputStream(in);
                int i = in.read();
                while (i != -1) {
                    sb.append((char)i);
                    i = in.read();
                }
                String content = sb.toString();
                char[] cArray = content.toCharArray();
                return cArray;
            }
            catch (Exception e) {
                char[] cArray = null;
                return cArray;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

