/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;

public class TestASTConstruction
extends BaseTest {
    public void testA() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT A <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakeRulePlusInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : B+;\nB : 'a';");
        String string = " ( rule A ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT B <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"A").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRulePlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)+;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRulePlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b+;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)?;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRuleOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b?;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)*;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRuleStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b*;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharStar() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharStarInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'*;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testStringStar() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'while'*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testStringStarInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'while'*;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharPlus() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'+;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharPlusInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'+;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharOptional() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'?;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharOptionalInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'?;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharRangePlus() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nID : 'a'..'z'+;");
        String string = " ( rule ID ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( .. 'a' 'z' ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"ID").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testLabel() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=ID;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( = x ID ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testLabelOfOptional() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=ID?;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT ( = x ID ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testLabelOfClosure() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=ID*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT ( = x ID ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleLabel() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=b;\nb : ID;\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( = x b ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testSetLabel() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=(A|B);\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( = x ( BLOCK ( ALT A <end-of-alt> ) ( ALT B <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNotSetLabel() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=~(A|B);\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( = x ( ~ ( BLOCK ( ALT A <end-of-alt> ) ( ALT B <end-of-alt> ) <end-of-block> ) ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNotSetListLabel() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x+=~(A|B);\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( += x ( ~ ( BLOCK ( ALT A <end-of-alt> ) ( ALT B <end-of-alt> ) <end-of-block> ) ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNotSetListLabelInLoop() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x+=~(A|B)+;\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( += x ( ~ ( BLOCK ( ALT A <end-of-alt> ) ( ALT B <end-of-alt> ) <end-of-block> ) ) ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleLabelOfPositiveClosure() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x=b+;\nb : ID;\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( = x b ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testListLabelOfClosure() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x+=ID*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT ( += x ID ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testListLabelOfClosure2() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : x+='int'*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT ( += x 'int' ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleListLabelOfPositiveClosure() throws Exception {
        Grammar grammar = new Grammar("grammar P;\noptions {output=AST;}\na : x+=b+;\nb : ID;\n");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( += x b ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRootTokenInStarLoop() throws Exception {
        Grammar grammar = new Grammar("grammar Expr;\noptions { backtrack=true; }\na : ('*'^)* ;\n");
        String string = " ( rule synpred1_Expr ARG RET scope ( BLOCK ( ALT '*' <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"synpred1_Expr").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testActionInStarLoop() throws Exception {
        Grammar grammar = new Grammar("grammar Expr;\noptions { backtrack=true; }\na : ({blort} 'x')* ;\n");
        String string = " ( rule synpred1_Expr ARG RET scope ( BLOCK ( ALT blort 'x' <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"synpred1_Expr").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }
}

