/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.common.InternalFactHandle;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public class RightTupleList
implements RightTupleMemory,
Entry {
    private static final long serialVersionUID = 400L;
    public Entry previous;
    public Entry next;
    public RightTuple first;
    public RightTuple last;
    private int hashCode;
    private AbstractHashTable.Index index;
    private TupleHashTableIterator iterator;

    public RightTupleList() {
        this.hashCode = 0;
        this.index = null;
    }

    public RightTupleList(AbstractHashTable.Index index, int hashCode) {
        this.index = index;
        this.hashCode = hashCode;
    }

    public RightTuple getFirst(LeftTuple leftTuple) {
        return this.first;
    }

    public RightTuple getLast(LeftTuple leftTuple) {
        return this.last;
    }

    public void add(RightTuple rightTuple) {
        if (this.first != null) {
            this.first.setPrevious(rightTuple);
            rightTuple.setNext(this.first);
            this.first = rightTuple;
        } else {
            this.first = rightTuple;
            this.last = rightTuple;
        }
    }

    public void remove(RightTuple rightTuple) {
        RightTuple previous = (RightTuple)rightTuple.getPrevious();
        RightTuple next = (RightTuple)rightTuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first = next;
            next.setPrevious(null);
        } else if (previous != null) {
            this.last = previous;
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
    }

    public RightTuple get(InternalFactHandle handle) {
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(InternalFactHandle handle) {
        return this.get(handle) != null;
    }

    public RightTuple get(RightTuple rightTuple) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(RightTuple rightTuple) {
        return this.get(rightTuple) != null;
    }

    public int size() {
        int i = 0;
        RightTuple current = this.first;
        while (current != null) {
            current = (RightTuple)current.getNext();
            ++i;
        }
        return i;
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new TupleHashTableIterator();
        }
        this.iterator.reset(this.first);
        return this.iterator;
    }

    public boolean matches(Object object, int objectHashCode) {
        return this.hashCode == objectHashCode && this.index.equal(this.first.getFactHandle().getObject(), object);
    }

    public boolean matches(LeftTuple tuple, int tupleHashCode) {
        return this.hashCode == tupleHashCode && this.index.equal(this.first.getFactHandle().getObject(), tuple);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        RightTupleList other = (RightTupleList)object;
        return this.hashCode == other.hashCode && this.index == other.index;
    }

    public Entry getPrevious() {
        return null;
    }

    public void setPrevious(Entry previous) {
    }

    public Entry getNext() {
        return this.next;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public boolean isIndexed() {
        return this.index != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (RightTuple rightTuple = this.first; rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            builder.append(rightTuple);
        }
        return builder.toString();
    }

    public static class TupleHashTableIterator
    implements Iterator {
        private RightTuple current;

        public void reset(RightTuple first) {
            this.current = first;
        }

        public Object next() {
            if (this.current != null) {
                RightTuple returnValue = this.current;
                this.current = (RightTuple)this.current.getNext();
                return returnValue;
            }
            return null;
        }

        public void remove() {
        }
    }
}

